/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.pool;

import com.esms.HostInfo;
import com.esms.common.ConnectionSupport;
import com.esms.common.pool.SocketObject;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class SocketObjectFactory
extends BaseKeyedPoolableObjectFactory {
    public static final Integer KEY_GW_MT = 1;
    public static final Integer KEY_GW_MO = 2;
    private static long maxIdleTime = 60000L;
    private HostInfo proxyHost;
    private HostInfo gwMtHost;
    private HostInfo gwMoHost;
    private boolean isInShortMode = false;

    public Object makeObject(Object key) throws Exception {
        if (KEY_GW_MT.equals(key)) {
            return ConnectionSupport.getValidSockObj(this.proxyHost, this.gwMtHost);
        }
        return ConnectionSupport.getValidSockObj(this.proxyHost, this.gwMoHost);
    }

    public boolean validateObject(Object key, Object obj) {
        SocketObject sockObj = (SocketObject)obj;
        long lastUsedTime = sockObj.getLastUsedTime();
        long curTime = System.currentTimeMillis();
        sockObj.setLastUsedTime(curTime);
        if (curTime - lastUsedTime < maxIdleTime) {
            return sockObj.isValid();
        }
        return false;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        SocketObject sockObj = (SocketObject)obj;
        sockObj.destory();
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        if (this.isInShortMode) {
            this.destroyObject(key, obj);
        }
    }

    public HostInfo getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(HostInfo proxyHost) {
        this.proxyHost = proxyHost;
    }

    public HostInfo getGwMtHost() {
        return this.gwMtHost;
    }

    public void setGwMtHost(HostInfo gwMtHost) {
        this.gwMtHost = gwMtHost;
    }

    public HostInfo getGwMoHost() {
        return this.gwMoHost;
    }

    public void setGwMoHost(HostInfo gwMoHost) {
        this.gwMoHost = gwMoHost;
    }

    public void setInShortMode(boolean isInShortMode) {
        this.isInShortMode = isInShortMode;
    }
}

