/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.pool;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class SocketObject {
    private Socket socket;
    private DataInputStream dis;
    private DataOutputStream dos;
    private BufferedReader reader;
    private boolean isLogin = false;
    private long lastUsedTime = System.currentTimeMillis();

    public SocketObject() {
    }

    public SocketObject(Socket socket) throws IOException {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("the socket should not be null or closed!");
        }
        this.socket = socket;
        this.dis = new DataInputStream(socket.getInputStream());
        this.dos = new DataOutputStream(socket.getOutputStream());
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public DataInputStream getDis() {
        return this.dis;
    }

    public void setDis(DataInputStream dis) {
        this.dis = dis;
    }

    public DataOutputStream getDos() {
        return this.dos;
    }

    public void setDos(DataOutputStream dos) {
        this.dos = dos;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(long lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public boolean isValid() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public void destory() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.dis != null) {
                this.dis.close();
            }
            if (this.dos != null) {
                this.dos.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

