/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.MessageData;
import com.esms.common.CommonResult;
import com.esms.common.entity.Account;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MediaItem;
import com.esms.common.util.UUIDUtil;
import com.esms.common.util.ZipUtil;
import com.google.protobuf.ByteString;
import com.xuanwu.msggate.common.protobuf.CommonItem;
import com.xuanwu.msggate.common.protobuf.mt.MTRequest;
import com.xuanwu.msggate.common.protobuf.mt.MTResponse;
import java.io.IOException;
import java.util.UUID;

public class MTSupport {
    private static final String FROM_CODE = "SDK_JAVA";

    public static byte[] getLoginBytes(Account account) {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        builder.setUuid(UUIDUtil.tranUUID2Builder(UUID.randomUUID()));
        builder.setType(MTRequest.TRequestType.LOGIN);
        CommonItem.Account.Builder acc = CommonItem.Account.newBuilder();
        acc.setName(account.getName());
        acc.setPassword(account.getPassword());
        builder.setUser(acc);
        return builder.build().toByteArray();
    }

    public static byte[] getSendBytes(Account account, MTPack pack) throws IOException {
        MTRequest.TRequest.Builder builder = MTRequest.TRequest.newBuilder();
        if (pack.getBatchID() == null) {
            pack.setBatchID(UUID.randomUUID());
        }
        builder.setUuid(UUIDUtil.tranUUID2Builder(pack.getBatchID()));
        if (pack.getCustomNum() != null) {
            builder.setCustomNum(pack.getCustomNum());
        }
        CommonItem.BizMeta.Builder biz = CommonItem.BizMeta.newBuilder();
        biz.setLevel(0);
        biz.setPriority(0);
        biz.setMsgType(pack.getMsgType().getIndex());
        biz.setSendType(pack.getSendType().ordinal());
        if (pack.getScheduleTime() > 0L) {
            biz.setScheduleTime(pack.getScheduleTime());
        }
        if (pack.getDeadline() > 0L) {
            biz.setDeadline(pack.getDeadline());
        }
        if (pack.getRemark() != null) {
            builder.setRemark(pack.getRemark());
        }
        biz.setBizType(pack.getBizType());
        builder.setInfo(biz);
        builder.setType(MTRequest.TRequestType.MESSAGE_SENT);
        builder.setFrom(FROM_CODE);
        if (pack.getBatchName() != null) {
            builder.setBatchName(pack.getBatchName());
        }
        builder.setDistinctFlag(pack.isDistinctFlag());
        if (pack.getMedias() != null) {
            for (MediaItem mItem : pack.getMedias()) {
                CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                temp.setMediaType(mItem.getMediaType());
                temp.setMeta(mItem.getMeta());
                temp.setData(ByteString.copyFrom((byte[])mItem.getData()));
                builder.addMmsAttachment(temp);
            }
        }
        switch (pack.getSendType()) {
            case MASS: {
                CommonItem.MassPack.Builder massmsg = CommonItem.MassPack.newBuilder();
                MessageData msg0 = pack.getMsgs().get(0);
                CommonItem.MsgContent.Builder contentMass = CommonItem.MsgContent.newBuilder();
                contentMass.setContent(msg0.getContent());
                massmsg.setContent(contentMass);
                for (MessageData msg : pack.getMsgs()) {
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    item.setPhone(msg.getPhone());
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    massmsg.addItems(item);
                }
                builder.setMassMsg(ByteString.copyFrom((byte[])ZipUtil.zipByteArray(massmsg.build().toByteArray())));
                break;
            }
            case GROUP: {
                CommonItem.GroupPack.Builder groupmsg = CommonItem.GroupPack.newBuilder();
                for (MessageData msg : pack.getMsgs()) {
                    CommonItem.MsgItem.Builder item = CommonItem.MsgItem.newBuilder();
                    CommonItem.MsgContent.Builder contentGroup = CommonItem.MsgContent.newBuilder();
                    item.setPhone(msg.getPhone());
                    contentGroup.setContent(msg.getContent());
                    if (msg.getMedias() != null) {
                        for (MediaItem mItem : msg.getMedias()) {
                            CommonItem.MediaItem.Builder temp = CommonItem.MediaItem.newBuilder();
                            temp.setMediaType(mItem.getMediaType());
                            temp.setMeta(mItem.getMeta());
                            temp.setData(ByteString.copyFrom((byte[])mItem.getData()));
                            contentGroup.addMedias(temp);
                        }
                    }
                    if (msg.getCustomMsgID() != null) {
                        item.setCustomMsgID(msg.getCustomMsgID());
                    }
                    if (msg.getCustomNum() != null) {
                        item.setCustomNum(msg.getCustomNum());
                    }
                    item.setVipFlag(msg.isVipFlag());
                    item.setContent(contentGroup);
                    groupmsg.addItems(item);
                }
                builder.setGroupMsg(ByteString.copyFrom((byte[])ZipUtil.zipByteArray(groupmsg.build().toByteArray())));
                break;
            }
        }
        return builder.build().toByteArray();
    }

    public static boolean isLoginSuc(byte[] srcBytes) throws IOException {
        GsmsResponse resp = MTSupport.getResponse(srcBytes);
        return resp.getResult() == CommonResult.SUCCESS;
    }

    public static GsmsResponse getResponse(byte[] srcBytes) throws IOException {
        MTResponse.TResponse.Builder builder = MTResponse.TResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        GsmsResponse resp = new GsmsResponse();
        resp.setMessage(builder.getMessage());
        resp.setResult(CommonResult.getType(builder.getResult().getNumber()));
        resp.setUuid(UUIDUtil.tranBuilder2UUID(builder.getUuid()));
        resp.setAttributes(builder.getAttributes());
        return resp;
    }

    public static void verifyPack(MTPack pack) {
        if (pack == null) {
            throw new NullPointerException("pack");
        }
        if (pack.getMsgs() == null || pack.getMsgs().size() < 1) {
            throw new IllegalArgumentException("msgs is empty");
        }
        if (pack.getSendType() == null) {
            throw new NullPointerException("sendType");
        }
        if (pack.getMsgType() == null) {
            throw new NullPointerException("msgType");
        }
    }

    public static GsmsResponse getResponse(CommonResult result, String message) {
        GsmsResponse resp = new GsmsResponse();
        resp.setResult(CommonResult.getType(result.getIndex()));
        if (message != null) {
            resp.setMessage(message);
        }
        return resp;
    }
}

