/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.MOMsg;
import com.esms.common.CommonResult;
import com.esms.common.entity.Account;
import com.esms.common.entity.AccountInfo;
import com.esms.common.entity.BindChannel;
import com.esms.common.entity.BusinessType;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import com.esms.common.util.UUIDUtil;
import com.esms.common.util.ZipUtil;
import com.google.protobuf.InvalidProtocolBufferException;
import com.xuanwu.msggate.common.protobuf.CommonItem;
import com.xuanwu.msggate.common.protobuf.mo.MORequest;
import com.xuanwu.msggate.common.protobuf.mo.MOResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;

public class MOSupport {
    public static byte[] getLoginBytes(Account account) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.LOGIN);
        CommonItem.Account.Builder acBuilder = CommonItem.Account.newBuilder();
        acBuilder.setName(account.getName());
        acBuilder.setPassword(account.getPassword());
        builder.setUser(acBuilder.build());
        return builder.build().toByteArray();
    }

    public static boolean isLoginSuc(byte[] srcBytes) throws InvalidProtocolBufferException {
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        if (builder.getType() == CommonItem.OMsgType.LOGIN && builder.getResult() == CommonItem.Result.SUCCESS) {
            return true;
        }
        throw new RuntimeException(builder.getResult().getNumber() + ", " + builder.getResult().name() + ", " + builder.getMessage());
    }

    public static byte[] getAcInfoReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.ACCOUNT_INFO);
        return builder.build().toByteArray();
    }

    public static byte[] getBizTypeReq() {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.BIZ_TYPE);
        return builder.build().toByteArray();
    }

    public static byte[] getModifyPwdReq(String newPwd) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MODIFY_PWD);
        builder.setNewPwd(newPwd);
        return builder.build().toByteArray();
    }

    public static byte[] getMOReq(int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.MO);
        builder.setPageSize(fetchSize);
        return builder.build().toByteArray();
    }

    public static byte[] getFindRespReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_RESP);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getRespReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.RESP);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        return builder.build().toByteArray();
    }

    public static byte[] getFindReportReq(UUID batchID, String phone, int pageIndex, boolean isSimple) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.FIND_REPORT);
        if (batchID != null) {
            builder.setBatchID(batchID.toString());
        }
        if (phone != null) {
            builder.setPhone(phone);
        }
        builder.setIsSimple(isSimple);
        builder.setPageIndex(pageIndex);
        return builder.build().toByteArray();
    }

    public static byte[] getReportReq(int limitDays, int fetchSize) {
        MORequest.ORequest.Builder builder = MOSupport.getReq(CommonItem.OMsgType.REPORT);
        builder.setDays(limitDays);
        builder.setPageSize(fetchSize);
        return builder.build().toByteArray();
    }

    public static MTResponse[] toResps(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.RESP && builder.getType() != CommonItem.OMsgType.FIND_RESP) {
            return null;
        }
        CommonItem.RespPack.Builder respPack = CommonItem.RespPack.newBuilder();
        respPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        if (respPack.getItemsList() == null) {
            return null;
        }
        ArrayList<MTResponse> resps = new ArrayList<MTResponse>();
        for (CommonItem.RespItem item : respPack.getItemsList()) {
            MTResponse resp = new MTResponse();
            resp.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            resp.setCustomMsgID(item.getCustomMsgID());
            resp.setMsgID(item.getMsgID());
            resp.setNumber(item.getNumber());
            resp.setOriginResult(item.getOriginResult());
            resp.setPhone(item.getPhone());
            resp.setState(item.getState());
            resp.setSubmitRespTime(item.getSubmitRespTime());
            resp.setTotal(item.getTotal());
            resp.setReserve(item.getReserve());
            resps.add(resp);
        }
        return resps.toArray(new MTResponse[resps.size()]);
    }

    public static MTReport[] toReports(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.REPORT && builder.getType() != CommonItem.OMsgType.FIND_REPORT) {
            return null;
        }
        CommonItem.ReportPack.Builder reportPack = CommonItem.ReportPack.newBuilder();
        reportPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        if (reportPack.getStateItemList() == null) {
            return null;
        }
        ArrayList<MTReport> reports = new ArrayList<MTReport>();
        for (CommonItem.StateItem item : reportPack.getStateItemList()) {
            MTReport report = new MTReport();
            report.setBatchID(UUIDUtil.tranBuilder2UUID(item.getBatchID()));
            report.setPhone(item.getDestPhone());
            report.setState(item.getState());
            report.setMsgID(item.getMsgID());
            report.setCustomMsgID(item.getCustomMsgID());
            report.setSubmitTime(item.getSubmitTime());
            report.setDoneTime(item.getDoneTime());
            report.setOriginResult(item.getOriginResult());
            report.setReserve(item.getReserve());
            reports.add(report);
        }
        return reports.toArray(new MTReport[reports.size()]);
    }

    public static MOMsg[] toMos(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.MO) {
            return null;
        }
        CommonItem.MOTicketPack.Builder moPack = CommonItem.MOTicketPack.newBuilder();
        moPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        if (moPack.getItemsList() == null) {
            return null;
        }
        ArrayList<MOMsg> mos = new ArrayList<MOMsg>();
        for (CommonItem.MOTicket item : moPack.getItemsList()) {
            MOMsg mo = new MOMsg();
            mo.setPhone(item.getPhone());
            mo.setContent(item.getContent());
            mo.setMsgType(item.getType());
            mo.setSepcNumber(item.getSpecNumber());
            mo.setServiceType(item.getServiceType());
            mo.setRecevieTime(item.getPostTime());
            mos.add(mo);
        }
        return mos.toArray(new MOMsg[mos.size()]);
    }

    public static AccountInfo toAcInfo(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.ACCOUNT_INFO) {
            return null;
        }
        MOResponse.AccountInfo.Builder acInfoBuilder = MOResponse.AccountInfo.newBuilder();
        acInfoBuilder.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        AccountInfo acInfo = new AccountInfo();
        acInfo.setAccount(acInfoBuilder.getAccount());
        acInfo.setName(acInfoBuilder.getName());
        acInfo.setIdentify(acInfoBuilder.getIdentify());
        acInfo.setUserBrief(acInfoBuilder.getSignature());
        acInfo.setBizNames(acInfoBuilder.getBizNamesList().toArray(new String[0]));
        acInfo.setBalance((long)(acInfoBuilder.getBalance() * 100.0));
        return acInfo;
    }

    public static BusinessType[] toBizType(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.BIZ_TYPE) {
            return null;
        }
        MOResponse.BizTypePack.Builder bizPack = MOResponse.BizTypePack.newBuilder();
        bizPack.mergeFrom(ZipUtil.unzipByteArray(builder.getData()));
        ArrayList<BusinessType> bizTypes = new ArrayList<BusinessType>();
        for (MOResponse.BusinessType biz : bizPack.getItemsList()) {
            BusinessType bizType = new BusinessType();
            bizType.setId(biz.getId());
            bizType.setName(biz.getName());
            bizType.setPriority(biz.getPriority());
            bizType.setStartTime(biz.getStartTime());
            bizType.setEndTime(biz.getEndTime());
            bizType.setExtendFlag(biz.getExtendFlag());
            bizType.setState(biz.getState());
            ArrayList<BindChannel> bindChs = new ArrayList<BindChannel>();
            for (MOResponse.BindChannel chBuilder : biz.getBindChsList()) {
                BindChannel bindCh = new BindChannel();
                bindCh.setCarrier(chBuilder.getCarrier());
                bindCh.setSpecNumber(chBuilder.getSpecNumber());
                bindCh.setSendType(chBuilder.getSendType());
                bindChs.add(bindCh);
            }
            bizType.setBindChs(bindChs);
            bizTypes.add(bizType);
        }
        return bizTypes.toArray(new BusinessType[bizTypes.size()]);
    }

    public static int toModifyPwdResult(byte[] srcBytes) throws IOException {
        MOResponse.OResponse.Builder builder = MOSupport.toRespBuilder(srcBytes);
        if (builder.getType() != CommonItem.OMsgType.MODIFY_PWD) {
            return CommonResult.OTHER_ERROR.getIndex();
        }
        return builder.getResult().getNumber();
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type) {
        return MOSupport.getReq(type, UUID.randomUUID());
    }

    private static MORequest.ORequest.Builder getReq(CommonItem.OMsgType type, UUID uuid) {
        MORequest.ORequest.Builder builder = MORequest.ORequest.newBuilder();
        builder.setType(type);
        builder.setUuid(UUIDUtil.tranUUID2Builder(uuid));
        return builder;
    }

    private static MOResponse.OResponse.Builder toRespBuilder(byte[] srcBytes) throws IOException {
        if (srcBytes == null) {
            throw new NullPointerException("srcBytes");
        }
        MOResponse.OResponse.Builder builder = MOResponse.OResponse.newBuilder();
        builder.mergeFrom(srcBytes);
        return builder;
    }
}

