/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.HostInfo;
import com.esms.MOMsg;
import com.esms.common.CommonResult;
import com.esms.common.MOSupport;
import com.esms.common.MTSupport;
import com.esms.common.entity.Account;
import com.esms.common.entity.AccountInfo;
import com.esms.common.entity.BusinessType;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import com.esms.common.pool.SocketObject;
import com.esms.common.pool.SocketObjectFactory;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class ProxyServer {
    private HostInfo proxyHost = new HostInfo("192.168.0.1", 0);
    private static int maxFrameLen = 0xA00000;
    private GenericKeyedObjectPool pool;
    @Deprecated
    public static final int PROXY_TYPE_DIRECT = 0;
    @Deprecated
    public static final int PROXY_TYPE_HTTP = 1;
    @Deprecated
    public static final int PROXY_TYPE_SOCKS4 = 2;
    @Deprecated
    public static final int PROXY_TYPE_SOCKS5 = 3;

    public ProxyServer(HostInfo gwHost, HostInfo wsHost, boolean isInShortMode) {
        SocketObjectFactory factory = new SocketObjectFactory();
        factory.setProxyHost(this.proxyHost);
        factory.setGwMtHost(gwHost);
        factory.setGwMoHost(wsHost);
        factory.setInShortMode(isInShortMode);
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)factory);
        this.pool.setTestOnBorrow(true);
        this.pool.setTestOnReturn(true);
        this.pool.setMaxActive(2);
        this.pool.setMaxIdle(1);
        this.pool.setMaxTotal(6);
        this.pool.setWhenExhaustedAction((byte)1);
    }

    public void setProxy(HostInfo proxyHost) {
        this.proxyHost.setType(proxyHost.getType());
        this.proxyHost.setIp(proxyHost.getIp());
        this.proxyHost.setPort(proxyHost.getPort());
        this.proxyHost.setUsername(proxyHost.getUsername());
        this.proxyHost.setPassword(proxyHost.getPassword());
    }

    public HostInfo getProxy() {
        return this.proxyHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GsmsResponse sendMessage(Account account, MTPack pack) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MT);
        try {
            if (!sockObj.isLogin()) {
                GsmsResponse resp = MTSupport.getResponse(this.transfer(sockObj, MTSupport.getLoginBytes(account)));
                if (resp.getResult() == CommonResult.SUCCESS) {
                    sockObj.setLogin(true);
                } else {
                    GsmsResponse gsmsResponse = resp;
                    return gsmsResponse;
                }
            }
            if (sockObj.isLogin()) {
                GsmsResponse gsmsResponse = MTSupport.getResponse(this.transfer(sockObj, MTSupport.getSendBytes(account, pack)));
                return gsmsResponse;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MT, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountInfo(Account account) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                AccountInfo accountInfo = MOSupport.toAcInfo(this.transfer(sockObj, MOSupport.getAcInfoReq()));
                return accountInfo;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessType[] getBizTypes(Account account) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                BusinessType[] businessTypeArray = MOSupport.toBizType(this.transfer(sockObj, MOSupport.getBizTypeReq()));
                return businessTypeArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MOMsg[] getMOMsgs(Account account, int fetchSize) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                MOMsg[] mOMsgArray = MOSupport.toMos(this.transfer(sockObj, MOSupport.getMOReq(fetchSize)));
                return mOMsgArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTResponse[] getResps(Account account, int fetchSize, int limitDays) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                MTResponse[] mTResponseArray = MOSupport.toResps(this.transfer(sockObj, MOSupport.getRespReq(limitDays, fetchSize)));
                return mTResponseArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTResponse[] findResps(Account account, int pageIndex, UUID batchID, String phone, boolean isSimple) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                MTResponse[] mTResponseArray = MOSupport.toResps(this.transfer(sockObj, MOSupport.getFindRespReq(batchID, phone, pageIndex, isSimple)));
                return mTResponseArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTReport[] getReports(Account account, int fetchSize, int limitDays) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                MTReport[] mTReportArray = MOSupport.toReports(this.transfer(sockObj, MOSupport.getReportReq(limitDays, fetchSize)));
                return mTReportArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTReport[] findReports(Account account, int pageIndex, UUID batchID, String phone, boolean isSimple) throws Exception {
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                MTReport[] mTReportArray = MOSupport.toReports(this.transfer(sockObj, MOSupport.getFindReportReq(batchID, phone, pageIndex, isSimple)));
                return mTReportArray;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modifyPassword(Account account, String newPwd) throws Exception {
        String md5Pwd = DigestUtils.md5Hex((String)newPwd);
        SocketObject sockObj = (SocketObject)this.pool.borrowObject((Object)SocketObjectFactory.KEY_GW_MO);
        try {
            if (this.doMoLogin(sockObj, account)) {
                int n = MOSupport.toModifyPwdResult(this.transfer(sockObj, MOSupport.getModifyPwdReq(md5Pwd)));
                return n;
            }
        }
        finally {
            this.pool.returnObject((Object)SocketObjectFactory.KEY_GW_MO, (Object)sockObj);
        }
        return CommonResult.OTHER_ERROR.getIndex();
    }

    private boolean doMoLogin(SocketObject sockObj, Account account) throws IOException {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (sockObj.isLogin()) {
            return true;
        }
        if (MOSupport.isLoginSuc(this.transfer(sockObj, MOSupport.getLoginBytes(account)))) {
            sockObj.setLogin(true);
            return true;
        }
        return false;
    }

    private final byte[] transfer(SocketObject sockObj, byte[] sendBytes) throws IOException {
        if (sendBytes == null) {
            throw new NullPointerException("sendBytes");
        }
        try {
            sockObj.getDos().writeInt(sendBytes.length);
            sockObj.getDos().write(sendBytes);
            sockObj.getDos().flush();
            int recvLength = sockObj.getDis().readInt();
            if (recvLength > maxFrameLen || recvLength < 0) {
                sockObj.destory();
                throw new RuntimeException("Adjusted frame length exceeds " + maxFrameLen + ": " + recvLength);
            }
            byte[] recvBytes = new byte[recvLength];
            sockObj.getDis().readFully(recvBytes);
            return recvBytes;
        }
        catch (IOException e) {
            sockObj.destory();
            throw e;
        }
    }

    @Deprecated
    public HostInfo getHost() {
        if (this.proxyHost.getType() == HostInfo.ConnectionType.DIRECT) {
            return null;
        }
        return this.proxyHost;
    }

    @Deprecated
    public String getPassword() {
        return this.proxyHost.getPassword();
    }

    @Deprecated
    public int getType() {
        return this.proxyHost.getType().ordinal();
    }

    @Deprecated
    public String getUserName() {
        return this.proxyHost.getUsername();
    }

    public void setProxy(int proxyType, String proxyIp, int proxyPort, String proxyUserName, String proxyPassword) {
        HostInfo proxyHost = new HostInfo(proxyIp, proxyPort);
        proxyHost.setType(HostInfo.ConnectionType.getType(proxyType));
        proxyHost.setUsername(proxyUserName);
        proxyHost.setPassword(proxyPassword);
        this.setProxy(proxyHost);
    }

    public void setProxy(int proxyType, String proxyIp, int proxyPort) {
        this.setProxy(proxyType, proxyIp, proxyPort, "", "");
    }

    public void setProxy(int proxyType, HostInfo proxyHost, String proxyUserName, String proxyPassword) {
        this.setProxy(proxyType, proxyHost.getIp(), proxyHost.getPort(), proxyUserName, proxyPassword);
    }
}

