/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.common.util.CommonUtil;

public class HostInfo {
    private String ip;
    private int port;
    private String username;
    private String password;
    private ConnectionType type = ConnectionType.DIRECT;

    public HostInfo(String ip, int port) {
        this.setHost(ip, port);
    }

    public void setHost(String ip, int port) {
        if (!CommonUtil.isIP(ip)) {
            throw new IllegalArgumentException("Invalid IP Address");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.ip = ip;
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HostInfo)) {
            return false;
        }
        HostInfo sockAddr = (HostInfo)obj;
        boolean sameIP = false;
        sameIP = this.ip != null ? this.ip.equals(sockAddr.ip) : this.ip == null && sockAddr.ip == null;
        return sameIP && this.port == sockAddr.port;
    }

    public boolean needLogin() {
        return CommonUtil.isNotBlank(this.username);
    }

    public final int hashCode() {
        if (this.ip != null) {
            return this.ip.hashCode() + this.port;
        }
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public void setType(ConnectionType type) {
        this.type = type;
    }

    public void setIp(String ip) {
        if (!CommonUtil.isIP(ip)) {
            throw new IllegalArgumentException("Invalid IP Address");
        }
        this.ip = ip;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.port = port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        DIRECT(0),
        HTTP(1),
        SOCKET4(2),
        SOCKET5(3);

        private final int index;

        private ConnectionType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ConnectionType getType(int index) {
            switch (index) {
                case 0: {
                    return DIRECT;
                }
                case 1: {
                    return HTTP;
                }
                case 2: {
                    return SOCKET4;
                }
                case 3: {
                    return SOCKET5;
                }
            }
            return DIRECT;
        }
    }
}

