/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.spring.boot;

import com.google.common.base.Preconditions;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.shardingjdbc.api.MasterSlaveDataSourceFactory;
import io.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;
import io.shardingsphere.shardingjdbc.spring.boot.common.SpringBootConfigMapConfigurationProperties;
import io.shardingsphere.shardingjdbc.spring.boot.common.SpringBootPropertiesConfigurationProperties;
import io.shardingsphere.shardingjdbc.spring.boot.masterslave.SpringBootMasterSlaveRuleConfigurationProperties;
import io.shardingsphere.shardingjdbc.spring.boot.sharding.SpringBootShardingRuleConfigurationProperties;
import io.shardingsphere.shardingjdbc.spring.boot.util.PropertyUtil;
import io.shardingsphere.shardingjdbc.util.DataSourceUtil;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootMasterSlaveRuleConfigurationProperties.class, SpringBootConfigMapConfigurationProperties.class, SpringBootPropertiesConfigurationProperties.class})
public class SpringBootConfiguration
implements EnvironmentAware {
    private final SpringBootShardingRuleConfigurationProperties shardingProperties;
    private final SpringBootMasterSlaveRuleConfigurationProperties masterSlaveProperties;
    private final SpringBootConfigMapConfigurationProperties configMapProperties;
    private final SpringBootPropertiesConfigurationProperties propMapProperties;
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();

    @Bean
    public DataSource dataSource() throws SQLException {
        return null == this.masterSlaveProperties.getMasterDataSourceName() ? ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)this.shardingProperties.getShardingRuleConfiguration(), this.configMapProperties.getConfigMap(), (Properties)this.propMapProperties.getProps()) : MasterSlaveDataSourceFactory.createDataSource(this.dataSourceMap, (MasterSlaveRuleConfiguration)this.masterSlaveProperties.getMasterSlaveRuleConfiguration(), this.configMapProperties.getConfigMap(), (Properties)this.propMapProperties.getProps());
    }

    public final void setEnvironment(Environment environment) {
        this.setDataSourceMap(environment);
    }

    private void setDataSourceMap(Environment environment) {
        String prefix = "sharding.jdbc.datasource.";
        String dataSources = environment.getProperty(prefix + "names");
        for (String each : dataSources.split(",")) {
            try {
                Map dataSourceProps = PropertyUtil.handle(environment, prefix + each.trim(), Map.class);
                Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
                DataSource dataSource = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
                this.dataSourceMap.put(each, dataSource);
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingException("Can't find datasource type!", (Exception)ex);
            }
        }
    }

    @ConstructorProperties(value={"shardingProperties", "masterSlaveProperties", "configMapProperties", "propMapProperties"})
    public SpringBootConfiguration(SpringBootShardingRuleConfigurationProperties shardingProperties, SpringBootMasterSlaveRuleConfigurationProperties masterSlaveProperties, SpringBootConfigMapConfigurationProperties configMapProperties, SpringBootPropertiesConfigurationProperties propMapProperties) {
        this.shardingProperties = shardingProperties;
        this.masterSlaveProperties = masterSlaveProperties;
        this.configMapProperties = configMapProperties;
        this.propMapProperties = propMapProperties;
    }
}

