/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.connection;

import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.shardingjdbc.jdbc.core.statement.MasterSlavePreparedStatement;
import io.shardingsphere.shardingjdbc.jdbc.core.statement.MasterSlaveStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveConnection
extends AbstractConnectionAdapter {
    private final MasterSlaveDataSource masterSlaveDataSource;
    private final Map<String, DataSource> dataSourceMap;

    public MasterSlaveConnection(MasterSlaveDataSource masterSlaveDataSource, Map<String, DataSource> dataSourceMap) {
        this(masterSlaveDataSource, dataSourceMap, TransactionType.LOCAL);
    }

    public MasterSlaveConnection(MasterSlaveDataSource masterSlaveDataSource, Map<String, DataSource> dataSourceMap, TransactionType transactionType) {
        super(transactionType);
        this.masterSlaveDataSource = masterSlaveDataSource;
        this.dataSourceMap = dataSourceMap;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.masterSlaveDataSource.getMasterSlaveRule().getMasterDataSourceName()).getMetaData();
    }

    @Override
    public Statement createStatement() {
        return new MasterSlaveStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnNames);
    }

    public MasterSlaveDataSource getMasterSlaveDataSource() {
        return this.masterSlaveDataSource;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }
}

