/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.truncate.table;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLTruncateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleTruncateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLTruncateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerTruncateTableParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.truncate.table.AbstractTruncateTableParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class TruncateTableParserFactory {
    public static AbstractTruncateTableParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLTruncateTableParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleTruncateTableParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerTruncateTableParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLTruncateTableParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private TruncateTableParserFactory() {
    }
}

