/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.drop.index;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLDropIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleDropIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLDropIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerDropIndexParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.drop.index.AbstractDropIndexParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class DropIndexParserFactory {
    public static AbstractDropIndexParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDropIndexParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDropIndexParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDropIndexParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDropIndexParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private DropIndexParserFactory() {
    }
}

