/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.sql.statement.ddl;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.ColumnDefinition;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class AlterTableStatement
extends DDLStatement {
    private final List<ColumnDefinition> addColumns = new LinkedList<ColumnDefinition>();
    private final List<String> dropColumns = new LinkedList<String>();
    private final Map<String, ColumnDefinition> updateColumns = new LinkedHashMap<String, ColumnDefinition>();
    private final List<ColumnPositionSegment> positionChangedColumns = new LinkedList<ColumnPositionSegment>();
    private boolean dropPrimaryKey;
    private String newTableName;
    private TableMetaData tableMetaData;

    public Optional<ColumnDefinition> findColumnDefinition(String columnName, ShardingTableMetaData shardingTableMetaData) {
        Optional<ColumnDefinition> result = this.findColumnDefinitionFromMetaData(columnName, shardingTableMetaData);
        return result.isPresent() ? result : this.findColumnDefinitionFromCurrentAddClause(columnName);
    }

    public Optional<ColumnDefinition> findColumnDefinitionFromMetaData(String columnName, ShardingTableMetaData shardingTableMetaData) {
        if (!shardingTableMetaData.containsTable(this.getTables().getSingleTableName())) {
            return Optional.absent();
        }
        for (ColumnMetaData each : shardingTableMetaData.get(this.getTables().getSingleTableName()).getColumnMetaData()) {
            if (!columnName.equalsIgnoreCase(each.getColumnName())) continue;
            return Optional.of((Object)new ColumnDefinition(columnName, each.getColumnType(), null, each.isPrimaryKey()));
        }
        return Optional.absent();
    }

    private Optional<ColumnDefinition> findColumnDefinitionFromCurrentAddClause(String columnName) {
        for (ColumnDefinition each : this.addColumns) {
            if (!each.getName().equalsIgnoreCase(columnName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public List<ColumnDefinition> getAddColumns() {
        return this.addColumns;
    }

    public List<String> getDropColumns() {
        return this.dropColumns;
    }

    public Map<String, ColumnDefinition> getUpdateColumns() {
        return this.updateColumns;
    }

    public List<ColumnPositionSegment> getPositionChangedColumns() {
        return this.positionChangedColumns;
    }

    public boolean isDropPrimaryKey() {
        return this.dropPrimaryKey;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public void setDropPrimaryKey(boolean dropPrimaryKey) {
        this.dropPrimaryKey = dropPrimaryKey;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public void setTableMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
    }
}

