/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.optimizer.impl.ddl.dialect.mysql;

import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.parsing.antlr.optimizer.impl.ddl.AlterTableOptimizer;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MySQLAlterTableOptimizer
extends AlterTableOptimizer {
    @Override
    protected void adjustColumnDefinition(AlterTableStatement alterTableStatement, List<ColumnMetaData> newColumnMetaData) {
        if (alterTableStatement.getPositionChangedColumns().isEmpty()) {
            return;
        }
        if (alterTableStatement.getPositionChangedColumns().size() > 1) {
            Collections.sort(alterTableStatement.getPositionChangedColumns());
        }
        for (ColumnPositionSegment each : alterTableStatement.getPositionChangedColumns()) {
            if (null != each.getFirstColumn()) {
                this.adjustFirst(newColumnMetaData, each.getFirstColumn());
                continue;
            }
            this.adjustAfter(newColumnMetaData, each);
        }
    }

    private void adjustFirst(List<ColumnMetaData> newColumnMetaData, String columnName) {
        ColumnMetaData firstMetaData = null;
        Iterator<ColumnMetaData> iterator = newColumnMetaData.iterator();
        while (iterator.hasNext()) {
            ColumnMetaData each = iterator.next();
            if (!each.getColumnName().equals(columnName)) continue;
            firstMetaData = each;
            iterator.remove();
            break;
        }
        if (null != firstMetaData) {
            newColumnMetaData.add(0, firstMetaData);
        }
    }

    private void adjustAfter(List<ColumnMetaData> newColumnMetaData, ColumnPositionSegment columnPosition) {
        int afterIndex = -1;
        int adjustColumnIndex = -1;
        for (int i = 0; i < newColumnMetaData.size(); ++i) {
            if (newColumnMetaData.get(i).getColumnName().equals(columnPosition.getColumnName())) {
                adjustColumnIndex = i;
            }
            if (newColumnMetaData.get(i).getColumnName().equals(columnPosition.getAfterColumn())) {
                afterIndex = i;
            }
            if (adjustColumnIndex >= 0 && afterIndex >= 0) break;
        }
        if (adjustColumnIndex >= 0 && afterIndex >= 0 && adjustColumnIndex != afterIndex + 1) {
            ColumnMetaData adjustColumnMetaData = newColumnMetaData.remove(adjustColumnIndex);
            if (afterIndex < adjustColumnIndex) {
                ++afterIndex;
            }
            newColumnMetaData.add(afterIndex, adjustColumnMetaData);
        }
    }
}

