/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.ShardingOperator;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.ExpressionFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.SubqueryFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.AndConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.ConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.OrConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.BetweenValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.EqualsValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.InValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SQLRightValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.OrCondition;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLTextExpression;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class FromWhereFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        FromWhereSegment fromWhereSegment = (FromWhereSegment)sqlSegment;
        if (!fromWhereSegment.getConditions().getAndConditions().isEmpty()) {
            HashMap columnNameToTable = new HashMap();
            HashMap<String, Integer> columnNameCount = new HashMap<String, Integer>();
            this.fillColumnTableMap(sqlStatement, shardingTableMetaData, columnNameToTable, columnNameCount);
            OrCondition orCondition = this.filterShardingCondition(sqlStatement, fromWhereSegment.getConditions(), sql, shardingRule, columnNameToTable, columnNameCount, shardingTableMetaData);
            sqlStatement.getConditions().getOrCondition().getAndConditions().addAll(orCondition.getAndConditions());
        }
        if (!fromWhereSegment.getSubquerys().isEmpty()) {
            for (SubquerySegment each : fromWhereSegment.getSubquerys()) {
                new SubqueryFiller().fill(each, sqlStatement, sql, shardingRule, shardingTableMetaData);
            }
        }
        for (int count = 0; count < fromWhereSegment.getParameterCount(); ++count) {
            sqlStatement.increaseParametersIndex();
        }
    }

    private void fillColumnTableMap(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData, Map<String, String> columnNameToTable, Map<String, Integer> columnNameCount) {
        if (null == shardingTableMetaData) {
            return;
        }
        for (String each : sqlStatement.getTables().getTableNames()) {
            Collection<String> tableColumns = shardingTableMetaData.getAllColumnNames(each);
            for (String columnName : tableColumns) {
                columnNameToTable.put(columnName, each);
                Integer count = columnNameCount.get(columnName);
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                columnNameCount.put(columnName, count);
            }
        }
    }

    private OrCondition filterShardingCondition(SQLStatement sqlStatement, OrConditionSegment orCondition, String sql, ShardingRule shardingRule, Map<String, String> columnNameToTable, Map<String, Integer> columnNameCount, ShardingTableMetaData shardingTableMetaData) {
        OrCondition result = new OrCondition();
        for (AndConditionSegment each : orCondition.getAndConditions()) {
            LinkedList<ConditionSegment> shardingCondition = new LinkedList<ConditionSegment>();
            boolean needSharding = false;
            for (ConditionSegment condition : each.getConditions()) {
                if (null == condition.getColumn()) continue;
                if (condition.getColumn().getOwner().isPresent() && sqlStatement.getTables().getTableNames().contains(condition.getColumn().getOwner().get())) {
                    sqlStatement.addSQLToken(new TableToken(condition.getColumn().getStartPosition(), 0, (String)condition.getColumn().getOwner().get()));
                }
                if (condition.getExpression() instanceof ColumnSegment) {
                    ColumnSegment rightColumn = (ColumnSegment)condition.getExpression();
                    if (rightColumn.getOwner().isPresent() && sqlStatement.getTables().getTableNames().contains(rightColumn.getOwner().get())) {
                        sqlStatement.addSQLToken(new TableToken(rightColumn.getStartPosition(), 0, (String)rightColumn.getOwner().get()));
                    }
                    needSharding = true;
                    continue;
                }
                if ("".equals(condition.getColumn().getTableName())) {
                    if (sqlStatement.getTables().isSingleTable()) {
                        condition.getColumn().setTableName(sqlStatement.getTables().getSingleTableName());
                    } else {
                        String tableName = columnNameToTable.get(condition.getColumn().getName());
                        Integer count = columnNameCount.get(condition.getColumn().getName());
                        if (null != tableName && 1 == count) {
                            condition.getColumn().setTableName(tableName);
                        }
                    }
                }
                if (!shardingRule.isShardingColumn(new Column(condition.getColumn().getName(), condition.getColumn().getTableName()))) continue;
                shardingCondition.add(condition);
                needSharding = true;
            }
            if (needSharding) {
                this.fillResult(result, sqlStatement, shardingCondition, sql, shardingRule, shardingTableMetaData);
                continue;
            }
            result.getAndConditions().clear();
            break;
        }
        return result;
    }

    private void fillResult(OrCondition result, SQLStatement sqlStatement, List<ConditionSegment> shardingCondition, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        if (shardingCondition.isEmpty()) {
            return;
        }
        AndCondition andConditionResult = new AndCondition();
        result.getAndConditions().add(andConditionResult);
        for (ConditionSegment eachCondition : shardingCondition) {
            Optional<SQLExpression> endExpress;
            Optional<SQLExpression> beginExpress;
            SQLRightValueExpressionSegment expressionSegment;
            Column column = new Column(eachCondition.getColumn().getName(), eachCondition.getColumn().getTableName());
            if (ShardingOperator.EQUAL == eachCondition.getOperator()) {
                expressionSegment = (EqualsValueExpressionSegment)eachCondition.getExpression();
                Optional<SQLExpression> expression = this.buildExpression((SelectStatement)sqlStatement, ((EqualsValueExpressionSegment)expressionSegment).getExpression(), sql, shardingRule, shardingTableMetaData);
                if (!expression.isPresent()) continue;
                andConditionResult.getConditions().add(new Condition(column, (SQLExpression)expression.get()));
                continue;
            }
            if (ShardingOperator.IN == eachCondition.getOperator()) {
                expressionSegment = (InValueExpressionSegment)eachCondition.getExpression();
                LinkedList<SQLExpression> expressions = new LinkedList<SQLExpression>();
                for (ExpressionSegment each : ((InValueExpressionSegment)expressionSegment).getSqlExpressions()) {
                    Optional<SQLExpression> expression = this.buildExpression((SelectStatement)sqlStatement, each, sql, shardingRule, shardingTableMetaData);
                    if (expression.isPresent()) {
                        expressions.add((SQLExpression)expression.get());
                        continue;
                    }
                    expressions.clear();
                    break;
                }
                if (expressions.isEmpty()) continue;
                andConditionResult.getConditions().add(new Condition(column, expressions));
                continue;
            }
            if (ShardingOperator.BETWEEN != eachCondition.getOperator() || !(beginExpress = this.buildExpression((SelectStatement)sqlStatement, ((BetweenValueExpressionSegment)(expressionSegment = (BetweenValueExpressionSegment)eachCondition.getExpression())).getBeginExpress(), sql, shardingRule, shardingTableMetaData)).isPresent() || !(endExpress = this.buildExpression((SelectStatement)sqlStatement, ((BetweenValueExpressionSegment)expressionSegment).getEndExpress(), sql, shardingRule, shardingTableMetaData)).isPresent()) continue;
            andConditionResult.getConditions().add(new Condition(column, (SQLExpression)beginExpress.get(), (SQLExpression)endExpress.get()));
        }
    }

    private Optional<SQLExpression> buildExpression(SelectStatement selectStatement, ExpressionSegment expressionSegment, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        if (!(expressionSegment instanceof CommonExpressionSegment)) {
            new ExpressionFiller().fill(expressionSegment, selectStatement, sql, shardingRule, shardingTableMetaData);
            return Optional.absent();
        }
        CommonExpressionSegment commonExpressionSegment = (CommonExpressionSegment)expressionSegment;
        if (-1 < commonExpressionSegment.getIndex()) {
            return Optional.of((Object)new SQLPlaceholderExpression(commonExpressionSegment.getIndex()));
        }
        if (null != commonExpressionSegment.getValue()) {
            return Optional.of((Object)new SQLNumberExpression(commonExpressionSegment.getValue()));
        }
        String expression = sql.substring(commonExpressionSegment.getStartPosition(), commonExpressionSegment.getEndPosition() + 1);
        return Optional.of((Object)new SQLTextExpression(expression));
    }
}

