/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.ColumnDefinition;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;

public final class ColumnDefinitionFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        ColumnDefinitionSegment columnExtractResult = (ColumnDefinitionSegment)sqlSegment;
        if (sqlStatement instanceof AlterTableStatement) {
            this.fillAlter(columnExtractResult, (AlterTableStatement)sqlStatement, shardingTableMetaData);
        } else if (sqlStatement instanceof CreateTableStatement) {
            this.fillCreate(columnExtractResult, (CreateTableStatement)sqlStatement);
        }
    }

    private void fillAlter(ColumnDefinitionSegment columnDefinitionSegment, AlterTableStatement alterTableStatement, ShardingTableMetaData shardingTableMetaData) {
        String oldName = columnDefinitionSegment.getOldName();
        if (null != oldName) {
            Optional<ColumnDefinition> oldDefinition = alterTableStatement.findColumnDefinition(oldName, shardingTableMetaData);
            if (!oldDefinition.isPresent()) {
                return;
            }
            ((ColumnDefinition)oldDefinition.get()).setName(columnDefinitionSegment.getName());
            if (null != columnDefinitionSegment.getType()) {
                ((ColumnDefinition)oldDefinition.get()).setType(columnDefinitionSegment.getType());
                ((ColumnDefinition)oldDefinition.get()).setLength(columnDefinitionSegment.getLength());
            }
            alterTableStatement.getUpdateColumns().put(oldName, (ColumnDefinition)oldDefinition.get());
        } else {
            ColumnDefinition columnDefinition = new ColumnDefinition(columnDefinitionSegment.getName(), columnDefinitionSegment.getType(), columnDefinitionSegment.getLength(), columnDefinitionSegment.isPrimaryKey());
            if (!columnDefinitionSegment.isAdd()) {
                alterTableStatement.getUpdateColumns().put(columnDefinitionSegment.getName(), columnDefinition);
            } else if (!alterTableStatement.findColumnDefinitionFromMetaData(columnDefinitionSegment.getName(), shardingTableMetaData).isPresent()) {
                alterTableStatement.getAddColumns().add(columnDefinition);
            }
        }
        if (null != columnDefinitionSegment.getPosition()) {
            alterTableStatement.getPositionChangedColumns().add(columnDefinitionSegment.getPosition());
        }
    }

    private void fillCreate(ColumnDefinitionSegment columnDefinitionSegment, CreateTableStatement createTableStatement) {
        createTableStatement.getColumnNames().add(SQLUtil.getExactlyValue(columnDefinitionSegment.getName()));
        createTableStatement.getColumnTypes().add(columnDefinitionSegment.getType());
        if (columnDefinitionSegment.isPrimaryKey()) {
            createTableStatement.getPrimaryKeyColumns().add(columnDefinitionSegment.getName());
        }
    }
}

