/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.dialect.sqlserver;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.transaction.TransactionOperationType;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.TransactionOperationTypeSegment;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.util.SQLUtil;
import org.antlr.v4.runtime.ParserRuleContext;

public final class SQLServerAutoCommitValueExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<TransactionOperationTypeSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> autoCommitValueNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.AUTO_COMMIT_VALUE);
        Preconditions.checkState((boolean)autoCommitValueNode.isPresent(), (Object)"Auto commit value is necessary.");
        if (DefaultKeyword.ON.name().equalsIgnoreCase(SQLUtil.getExactlyValue(((ParserRuleContext)autoCommitValueNode.get()).getText()))) {
            return Optional.of((Object)new TransactionOperationTypeSegment(TransactionOperationType.IGNORE));
        }
        return Optional.of((Object)new TransactionOperationTypeSegment(TransactionOperationType.BEGIN));
    }
}

