/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.FromWhereExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.GroupByExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.OrderByExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.SelectClauseExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.SelectClauseSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.GroupBySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderBySegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class SubqueryExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<SubquerySegment> extract(ParserRuleContext subqueryNode) {
        if (!RuleName.SUBQUERY.getName().endsWith(subqueryNode.getClass().getSimpleName())) {
            return Optional.absent();
        }
        boolean subqueryInFrom = false;
        for (ParserRuleContext parentNode = subqueryNode.getParent(); null != parentNode; parentNode = parentNode.getParent()) {
            if (!RuleName.FROM_CLAUSE.getName().equals(parentNode.getClass().getSimpleName())) continue;
            subqueryInFrom = true;
            break;
        }
        Optional<SelectClauseSegment> selectClauseSegment = new SelectClauseExtractor().extract(subqueryNode);
        Optional<FromWhereSegment> fromWhereSegment = new FromWhereExtractor().extract(subqueryNode);
        Optional<GroupBySegment> groupBySegment = new GroupByExtractor().extract(subqueryNode);
        Optional<OrderBySegment> orderBySegment = new OrderByExtractor().extract(subqueryNode);
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(subqueryNode.getParent(), RuleName.ALIAS);
        Optional alias = Optional.absent();
        if (aliasNode.isPresent()) {
            alias = Optional.of((Object)((ParserRuleContext)aliasNode.get()).getText());
        }
        return Optional.of((Object)new SubquerySegment(selectClauseSegment, fromWhereSegment, groupBySegment, orderBySegment, (Optional<String>)alias, subqueryInFrom));
    }
}

