/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ExpressionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.SelectClauseSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public final class SelectClauseExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<SelectClauseSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> selectExpressionNode;
        Optional<ParserRuleContext> selectClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        if (!selectClauseNode.isPresent()) {
            return Optional.absent();
        }
        boolean hasDistinct = false;
        if (2 < ((ParserRuleContext)selectClauseNode.get()).getChildCount() && DefaultKeyword.DISTINCT.name().equalsIgnoreCase(((ParserRuleContext)selectClauseNode.get()).getChild(1).getText())) {
            hasDistinct = true;
        }
        if (!(selectExpressionNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)selectClauseNode.get(), RuleName.SELECT_EXPRS)).isPresent()) {
            return Optional.absent();
        }
        SelectClauseSegment result = new SelectClauseSegment(((ParserRuleContext)selectExpressionNode.get()).getStop().getStopIndex() + 2);
        result.setHasDistinct(hasDistinct);
        ExpressionExtractor expressionExtractor = new ExpressionExtractor();
        for (int i = 0; i < ((ParserRuleContext)selectExpressionNode.get()).getChildCount(); ++i) {
            Optional<ExpressionSegment> expressionSegment;
            ParseTree childNode = ((ParserRuleContext)selectExpressionNode.get()).getChild(i);
            if (childNode instanceof TerminalNodeImpl || !(expressionSegment = expressionExtractor.extract((ParserRuleContext)childNode)).isPresent()) continue;
            result.getExpressions().add((ExpressionSegment)expressionSegment.get());
        }
        return Optional.of((Object)result);
    }
}

