/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.OrderDirection;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderBySegment;
import io.shardingsphere.core.parsing.parser.token.OrderByToken;
import io.shardingsphere.core.util.NumberUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;

public final class OrderByExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<OrderBySegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> selectClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        if (!selectClauseNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> orderByParentNode = ExtractorUtils.findFirstChildNodeNoneRecursive(((ParserRuleContext)selectClauseNode.get()).getParent(), RuleName.ORDER_BY_CLAUSE);
        if (!orderByParentNode.isPresent()) {
            return Optional.absent();
        }
        OrderBySegment result = new OrderBySegment();
        result.getOrderByItems().addAll(this.extractOrderBy((ParserRuleContext)orderByParentNode.get()));
        return Optional.of((Object)result);
    }

    protected Collection<OrderByItemSegment> extractOrderBy(ParserRuleContext orderByParentNode) {
        Collection<ParserRuleContext> orderByNodes = ExtractorUtils.getAllDescendantNodes(orderByParentNode, RuleName.ORDER_BY_ITEM);
        if (orderByNodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (ParserRuleContext each : orderByNodes) {
            int count = each.getChildCount();
            if (count == 0) continue;
            int index = -1;
            Optional<ParserRuleContext> numberNode = ExtractorUtils.findFirstChildNode(each, RuleName.NUMBER);
            if (numberNode.isPresent()) {
                index = NumberUtil.getExactlyNumber(((ParserRuleContext)numberNode.get()).getText(), 10).intValue();
            }
            boolean isIdentifier = RuleName.COLUMN_NAME.getName().equalsIgnoreCase(each.getChild(0).getClass().getSimpleName());
            OrderDirection orderDirection = OrderDirection.ASC;
            if (1 < count && OrderDirection.DESC.name().equalsIgnoreCase(each.getChild(count - 1).getText())) {
                orderDirection = OrderDirection.DESC;
            }
            ParserRuleContext firstChild = (ParserRuleContext)each.getChild(0);
            result.add(this.buildSegment(index, orderDirection, firstChild.getStart().getStartIndex(), firstChild.getStop().getStopIndex(), isIdentifier, orderByParentNode.getStart().getStartIndex()));
        }
        return result;
    }

    private OrderByItemSegment buildSegment(int index, OrderDirection orderDirection, int expressionStartPosition, int expressionEndPosition, boolean isIdentifier, int orderByItemStartPosition) {
        return new OrderByItemSegment(index, expressionStartPosition, expressionEndPosition, isIdentifier, new OrderByToken(orderByItemStartPosition), orderDirection, OrderDirection.ASC);
    }
}

