/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnDefinitionSegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class ColumnDefinitionExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ColumnDefinitionSegment> extract(ParserRuleContext columnDefinitionNode) {
        Optional<ParserRuleContext> columnNameNode = ExtractorUtils.findFirstChildNode(columnDefinitionNode, RuleName.COLUMN_NAME);
        if (!columnNameNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> dataTypeNode = ExtractorUtils.findFirstChildNode(columnDefinitionNode, RuleName.DATA_TYPE);
        Optional dataTypeText = dataTypeNode.isPresent() ? Optional.of((Object)((ParserRuleContext)dataTypeNode.get()).getChild(0).getText()) : Optional.absent();
        Optional<Integer> dataTypeLength = dataTypeNode.isPresent() ? this.getDataTypeLength((ParserRuleContext)dataTypeNode.get()) : Optional.absent();
        boolean isPrimaryKey = ExtractorUtils.findFirstChildNode(columnDefinitionNode, RuleName.PRIMARY_KEY).isPresent();
        return Optional.of((Object)new ColumnDefinitionSegment(((ParserRuleContext)columnNameNode.get()).getText(), (String)dataTypeText.orNull(), (Integer)dataTypeLength.orNull(), isPrimaryKey));
    }

    private Optional<Integer> getDataTypeLength(ParserRuleContext dataTypeContext) {
        Optional<ParserRuleContext> dataTypeLengthNode = ExtractorUtils.findFirstChildNode(dataTypeContext, RuleName.DATA_TYPE_LENGTH);
        if (!dataTypeLengthNode.isPresent() || ((ParserRuleContext)dataTypeLengthNode.get()).getChildCount() < 3) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Integer.parseInt(((ParserRuleContext)dataTypeLengthNode.get()).getChild(1).getText()));
        }
        catch (NumberFormatException ignored) {
            return Optional.absent();
        }
    }
}

