/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ClassUtils;

public abstract class KotlinDetector {
    private static final @Nullable Class<? extends Annotation> kotlinMetadata;
    private static final @Nullable Class<? extends Annotation> kotlinJvmInline;
    private static final @Nullable Class<?> kotlinCoroutineContinuation;
    private static final boolean kotlinPresent;
    private static final boolean kotlinReflectPresent;

    public static boolean isKotlinPresent() {
        return kotlinPresent;
    }

    public static boolean isKotlinReflectPresent() {
        return kotlinReflectPresent;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinPresent && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    public static boolean isSuspendingFunction(Method method) {
        if (kotlinCoroutineContinuation == null) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        return parameterCount > 0 && method.getParameterTypes()[parameterCount - 1] == kotlinCoroutineContinuation;
    }

    public static boolean isInlineClass(Class<?> clazz) {
        return kotlinJvmInline != null && clazz.getDeclaredAnnotation(kotlinJvmInline) != null;
    }

    static {
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        Class<?> metadata = null;
        Class<?> jvmInline = null;
        Class<?> coroutineContinuation = null;
        try {
            metadata = ClassUtils.forName("kotlin.Metadata", classLoader);
            try {
                jvmInline = ClassUtils.forName("kotlin.jvm.JvmInline", classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                coroutineContinuation = ClassUtils.forName("kotlin.coroutines.Continuation", classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        kotlinMetadata = metadata;
        kotlinPresent = kotlinMetadata != null;
        kotlinReflectPresent = ClassUtils.isPresent("kotlin.reflect.full.KClasses", classLoader);
        kotlinJvmInline = jvmInline;
        kotlinCoroutineContinuation = coroutineContinuation;
    }
}

