/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.presto.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterFunctionStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoCreateTableParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class PrestoStatementParser
extends SQLStatementParser {
    public PrestoStatementParser(String sql) {
        super(new PrestoExprParser(sql, new SQLParserFeature[0]));
    }

    public PrestoStatementParser(Lexer lexer) {
        super(new PrestoExprParser(lexer));
    }

    @Override
    public PrestoSelectParser createSQLSelectParser() {
        return new PrestoSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public PGSelectStatement parseSelect() {
        PrestoSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new PGSelectStatement(select);
    }

    @Override
    protected void parseInsertColumns(SQLInsertInto insert) {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        while (true) {
            SQLName expr = this.exprParser.name();
            expr.setParent(insert);
            insert.getColumns().add(expr);
            if (this.lexer.token() == Token.IDENTIFIER) {
                String text = this.lexer.stringVal();
                if (text.equalsIgnoreCase("TINYINT") || text.equalsIgnoreCase("BIGINT") || text.equalsIgnoreCase("INTEGER") || text.equalsIgnoreCase("DOUBLE") || text.equalsIgnoreCase("DATE") || text.equalsIgnoreCase("VARCHAR")) {
                    expr.getAttributes().put("dataType", text);
                    this.lexer.nextToken();
                } else if (text.equalsIgnoreCase("CHAR")) {
                    String dataType = text;
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    SQLExpr char_len = this.exprParser.primary();
                    this.accept(Token.RPAREN);
                    dataType = dataType + "(" + char_len.toString() + ")";
                    expr.getAttributes().put("dataType", dataType);
                }
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new PrestoCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseAlter() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.FUNCTION) {
            this.lexer.reset(mark);
            return this.parseAlterFunction();
        }
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.reset(mark);
            return this.parseAlterSchema();
        }
        this.lexer.reset(mark);
        return super.parseAlter();
    }

    @Override
    protected SQLStatement parseAlterFunction() {
        this.accept(Token.ALTER);
        this.accept(Token.FUNCTION);
        PrestoAlterFunctionStatement stmt = new PrestoAlterFunctionStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        if (this.lexer.token() == Token.LPAREN) {
            StringBuilder needAppendName = new StringBuilder();
            needAppendName.append("(");
            while (true) {
                this.lexer.nextToken();
                needAppendName.append(this.lexer.stringVal());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.RPAREN) break;
                if (this.lexer.token() != Token.COMMA) continue;
                needAppendName.append(",");
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.RPAREN) {
                    this.setErrorEndPos(this.lexer.pos());
                    throw new ParserException("syntax error, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
                }
                this.lexer.reset(mark);
            }
            this.accept(Token.RPAREN);
            needAppendName.append(")");
            if (needAppendName.length() > 0) {
                if (name instanceof SQLPropertyExpr) {
                    SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)name;
                    sqlPropertyExpr.setName(sqlPropertyExpr.getName() + needAppendName);
                } else if (name instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)name;
                    sqlIdentifierExpr.setName(sqlIdentifierExpr.getName() + needAppendName);
                }
            }
        }
        stmt.setName(name);
        if (this.lexer.identifierEquals("CALLED")) {
            this.lexer.nextToken();
            stmt.setCalledOnNullInput(true);
        } else if (this.lexer.identifierEquals("RETURNS")) {
            this.lexer.nextToken();
            this.acceptIdentifier("NULL");
            stmt.setCalledOnNullInput(true);
        } else {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
        }
        this.accept(Token.ON);
        this.accept(Token.NULL);
        this.acceptIdentifier("INPUT");
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        this.accept(Token.ALTER);
        this.accept(Token.SCHEMA);
        PrestoAlterSchemaStatement stmt = new PrestoAlterSchemaStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setSchemaName(name);
        this.acceptIdentifier("RENAME");
        this.accept(Token.TO);
        stmt.setNewName(this.exprParser.identifier());
        return stmt;
    }
}

