define(function(require , exports , module){
    var $ = require('jquery');
    var doc = document;
    var _wheelData=-1;
    var mouseDom = null;
    var contentTop = 0;
    var contentLeft = 0;
    var maxTop={};
    var maxLeft={};
    function bind(obj,type,handler){
        mouseDom=typeof obj=="string"?document.getElementById(obj):obj;
        if(mouseDom.addEventListener){
            mouseDom.addEventListener(type,handler,false);
        }else if(mouseDom.attachEvent){
            mouseDom.attachEvent('on'+type,handler);
        }else{
            mouseDom['on'+type]=handler;
        }
    }
    function _unbind(obj,type,handler){
        mouseDom=typeof obj=="string"?document.getElementById(obj):obj;
        if(mouseDom.removeEventListener){
            mouseDom.removeEventListener(type,handler,false);
        }else if(mouseDom.detachEvent){
            mouseDom.detachEvent('on'+type,handler);
        }else{
            mouseDom['on'+type]=handler;
        }
    }
    function mouseWheel(obj,handler,maxTop){
        var node=typeof obj=="string"?document.getElementById(obj):obj;
         bind(node,'mousewheel',function(event){
          var data=-getWheelData(event);
          handler(data);
          if(-[1,]){
              event.preventDefault();
          }else{
              window.event.returnValue=false;
          }
          
         });
         //ܰۼ
         bind(node,'DOMMouseScroll',function(event){
          var data=getWheelData(event);
          handler(data);
          event.preventDefault();
         });
         function getWheelData(event){
              var e=event||window.event;
              return e.wheelDelta?e.wheelDelta:e.detail*40;
         }
       }
    function addScroll(){
        this.init.apply(this,arguments);
    }
    addScroll.prototype={
            init:function(mainBox,contentBox,className,wClassName){
                $('.'+className).parent().remove();
                 this.mainBoxClass = mainBox;
                 maxTop[this.mainBoxClass] = false;
                 var mainBox=doc.getElementById(mainBox);
                 var contentBox=doc.getElementById(contentBox);
                 var scrollDiv=this._createScroll(mainBox,contentBox,className,wClassName);
                 this._resizeScorll(scrollDiv,mainBox,contentBox);
                 this._tragScroll(scrollDiv,mainBox,contentBox);
                 //this._wheelChange(scrollDiv,mainBox,contentBox);
                 this._clickScroll(scrollDiv,mainBox,contentBox);
                 
            },
            _createScroll:function(mainBox,contentBox,className,wClassName){
                var _scroll , _so = false;
                if(className){
                    var scroll_height_Box = $(mainBox).find('.scroll-height-Box');
                    if(scroll_height_Box.length > 0){
                        scroll_height_Box.remove();
                    }
                     var _scrollBox=doc.createElement('div')
                     _scrollBox.setAttribute('class','scroll-height-Box');
                     _scroll=doc.createElement('div');
                     var span=doc.createElement('span');
                     _scrollBox.appendChild(_scroll);
                     _scroll.appendChild(span);
                     _scroll.className=className;
                     mainBox.appendChild(_scrollBox);
                     
//                     $(_scrollBox).mouseenter(function(){
//                         _scroll.style.display = 'block';
//                         _so=true;
//                     }).mouseleave(function(){
//                         _scroll.style.display = 'none';
//                         _so=false;
//                     });
                    
                }
                 var _wScroll , _wo = false;
                 if(wClassName){
                     var scroll_width_Box = $(mainBox).find('.scroll-width-Box');
                     if(scroll_width_Box.length > 0){
                         scroll_width_Box.remove();
                     }
                     var _wScrollBox = doc.createElement('div');
                     _wScrollBox.setAttribute('class','scroll-width-Box');
                     _wScroll = doc.createElement('div');
                     var _wSpan = doc.createElement('span');
                     _wScrollBox.appendChild(_wScroll);
                     _wScroll.appendChild(_wSpan);
                     _wScroll.className = wClassName;
                     mainBox.appendChild(_wScrollBox);
                     
//                     $(_wScrollBox).mouseenter(function(){
//                         _wScroll.style.display = 'block';
//                         _wo=true;
//                     }).mouseleave(function(){
//                         _wScroll.style.display = 'none';
//                         _wo=false;
//                     });
                 }
                 
//                 $(contentBox).mouseenter(function(){
//                     if(className){
//                         _scroll.style.display = 'block';
//                     }
//                     if(wClassName){
//                         _wScroll.style.display = 'block';
//                     }
//                 }).mouseleave(function(){
//                     var me = this;
//                     setTimeout(function(){
//                         if(!_so && className){
//                             _scroll.style.display = 'none';
//                         }
//                         
//                         if(!_wo && wClassName){
//                             _wScroll.style.display = 'none';
//                         }
//                     },500);
//                 });

                 return [_scroll,_wScroll];
            },
            //ַֻڶ֯͵
            _resizeScorll:function(elements,mainBox,contentBox){
                if(elements[0]){
                    var element0 = elements[0];
                     var p=element0.parentNode;
                     var conHeight=contentBox.offsetHeight;
                     var _width=mainBox.clientWidth;
                     var _height=mainBox.clientHeight;
                     var _scrollWidth=element0.offsetWidth;
                     _scrollWidth = _scrollWidth <= 0 ? 10 : _scrollWidth;
                     var _left=_width-_scrollWidth;
                     p.style.width=_scrollWidth+"px";
                     p.style.height=_height+"px";
                     //p.style.left=_left+"px";
                     p.style.right=0;
                     p.style.position="absolute";
                     p.style.zIndex=100;
                     //p.style.background="#fff";
                     //contentBox.style.width=(mainBox.offsetWidth)+"px";
                     var _scrollHeight=parseInt(_height*(_height/contentBox.offsetHeight));
                     if(_scrollHeight>=mainBox.clientHeight){
                         element0.parentNode.style.display="none";
                         p.style.display = "none";
                         contentBox.style.top="0px";
                         maxTop[this.mainBoxClass] = true;
                     }else{
                         maxTop[this.mainBoxClass] = false;
                         p.style.display = "block";
                         this._wheelChange(elements,mainBox,contentBox);
                     }
                     element0.style.height=_scrollHeight+"px";
                }
                if(elements[1]){
                    var element1 = elements[1];
                    var wp=element1.parentNode;
                    var conWidth=contentBox.offsetWidth;
                    var _width=mainBox.clientWidth;
                    _width = _width <= 0 ? 10 : _width;
                    var _scrollWidth=element1.offsetWidth;
                    var _wHeight = element1.offsetHeight;
                    var _left=_width-_scrollWidth;
                    
                    wp.style.width=_width+"px";
                    wp.style.height=_wHeight+"px";
                    wp.style.left="0px";
                    wp.style.bottom="0px";
                    wp.style.position="fixed";
                    wp.style.zIndex=100;
                    //wp.style.background="#fff";

                    var _scrollWidth=parseInt(_width*(_width/conWidth));
                    if(_scrollWidth>=mainBox.clientWidth){
                        wp.style.display = "none";
                        contentBox.style.left="0px";
                        maxLeft[this.mainBoxClass] = true;
                    }else{
                        maxLeft[this.mainBoxClass] = false;
                        wp.style.display = "block";
                    }
                    element1.style.width=_scrollWidth+"px";
                }
            },
            //Ώ֯ڶ֯͵
            _tragScroll:function(elements,mainBox,contentBox){
                if(elements[0]){
                    var element0 = elements[0];
                     var mainHeight=mainBox.clientHeight;
                     element0.onmousedown=function(event){
                      var _this=this;
                      var _scrollTop=element0.offsetTop;
                      var e=event||window.event;
                      var top=e.clientY;
                      //this.onmousemove=scrollGo;
                      document.onmousemove=scrollGo;
                      document.onmouseup=function(event){
                       this.onmousemove=null;
                      }
                      function scrollGo(event){
                       var e=event||window.event;
                       var _top=e.clientY;
                       var _t=_top-top+_scrollTop;
                       if(_t>(mainHeight-element0.offsetHeight)){
                        _t=mainHeight-element0.offsetHeight;
                       }
                       if(_t<=0){
                        _t=0;
                       }
                       element0.style.top=_t+"px";
                       contentBox.style.top=-_t*(contentBox.offsetHeight/mainBox.offsetHeight)+"px";
                       _wheelData=_t;
                      }
                     }
                     element0.onmouseover=function(){
                      this.style.background="#ccc";
                     }
                     element0.onmouseout=function(){
                      this.style.background="#ccc"; 
                     }
                }
                
                if(elements[1]){
                    var element1 = elements[1];
                    var mainWidth=mainBox.clientWidth;
                    element1.onmousedown=function(event){
                     var _this=this;
                     var _scrollWidth=element1.offsetLeft;
                     var e=event||window.event;
                     var left=e.clientX;
                     //this.onmousemove=scrollGo;
                     document.onmousemove=wScrollGo;
                     document.onmouseup=function(event){
                      this.onmousemove=null;
                     }
                     function wScrollGo(event){
                      var e=event||window.event;
                      var _left=e.clientX;
                      var _l=_left-left+_scrollWidth;
                      if(_l>(mainWidth-element1.offsetWidth)){
                          _l=mainWidth-element1.offsetWidth;
                      }
                      if(_l<=0){
                          _l=0;
                      }
                      element1.style.left=_l+"px";
                      contentBox.style.left=-_l*(contentBox.offsetWidth/mainBox.offsetWidth)+"px";
                     }
                    }
                    element1.onmouseover=function(){
                     this.style.background="#ccc"; 
                    }
                    element1.onmouseout=function(){
                     this.style.background="#ccc"; 
                    }
                }
            },
            //˳ҪڶÖڶ֯ìڶ֯͵ڶ֯
            _wheelChange:function(elements,mainBox,contentBox){
                var element;
                if(elements[0]){
                    element = elements[0];
                    var me = this;
                    var node=typeof mainBox=="string"?$(mainBox):mainBox;
                    var flag=0,rate=0,wheelFlag=0;
                    if(node){
                     mouseWheel(node,function(data){
                      wheelFlag+=data;
                      if(_wheelData>=0){
                       flag=_wheelData;
                       element.style.top=flag+"px";
                       wheelFlag=_wheelData*12;
                       _wheelData=-1;
                      }else{
                       flag=wheelFlag/12;
                      }
                      if(flag<=0){
                       flag=0;
                       wheelFlag=0;
                      }
                      if(flag>=(mainBox.offsetHeight-element.offsetHeight)){
                       flag=(mainBox.clientHeight-element.offsetHeight);
                       wheelFlag=(mainBox.clientHeight-element.offsetHeight)*12;
                       
                      }
                      element.style.top=flag+"px";
                      contentTop = -flag*(contentBox.offsetHeight/mainBox.offsetHeight);
                      if(maxTop[me.mainBoxClass]){
                          if(parseInt(contentTop) >= 0){
                              contentBox.style.top=contentTop+"px";
                          }
                      }else{
                          contentBox.style.top=contentTop+"px";
                      }
                       
                     });
                    }
                }
                
                
                
            },
            _clickScroll:function(elements,mainBox,contentBox){
                 if(elements[0]){
                     var element0 = elements[0];
                     var p=element0.parentNode;
                     p.onclick=function(event){
                      var e=event||window.event;
                      var t=e.target||e.srcElement;
                      var sTop=document.documentElement.scrollTop>0?document.documentElement.scrollTop:document.body.scrollTop;
                      var top=mainBox.offsetTop;
                      var _top=e.clientY+sTop-top-element0.offsetHeight/2;
                      if(_top<=0){
                       _top=0;
                      }
                      if(_top>=(mainBox.clientHeight-element0.offsetHeight)){
                       _top=mainBox.clientHeight-element0.offsetHeight;
                      }
                      if(t!=element0){
                         element0.style.top=_top+"px";
                       contentBox.style.top=-_top*(contentBox.offsetHeight/mainBox.offsetHeight)+"px";
                       _wheelData=_top;
                      }
                     }
                 }
                 
                 if(elements[1]){
                     var element1 = elements[1];
                     var p=element1.parentNode;
                     p.onclick=function(event){
                      var e=event||window.event;
                      var t=e.target||e.srcElement;
                      var sLeft=document.documentElement.scrollLeft>0?document.documentElement.scrollLeft:document.body.scrollLeft;
                      var left=mainBox.offsetLeft;
                      var _left=e.clientX+sLeft-left-element1.offsetWidth/2;
                      if(_left<=0){
                       _left=0;
                      }
                      if(_left>=(mainBox.clientWidth-element1.offsetWidth)){
                       _left=mainBox.clientWidth-element1.offsetWidth;
                      }
                      if(t!=element1){
                       element1.style.left=_left+"px";
                       contentBox.style.left=-_left*(contentBox.offsetWidth/mainBox.offsetWidth)+"px";
                      }
                     }
                 }
            }
           }
    module.exports = addScroll;
});