/**
 * 安信工具类
 * 依赖jquery
 */
define("utils-debug", [ "jquery-debug" ], function(require, exports, module) {
    var Y = require("jquery-debug");
    var Utils, layerDate;
    /**
     * 全局固定配置
     */
    function globalConcat() {
        //时间插件配置
        this.laydate = function() {
            this.ld_skin = "danlan";
            //皮肤
            this.ld_elem = "#timeInput";
            //元素ID
            this.ld_format = "YYYY-MM-DD";
            //显示格式
            this.istoday = true;
            //显示今天
            this.ld_onload = function() {
                layerDate.skin(this.ld_skin);
                layerDate({
                    elem: "#" + this.ld_elem,
                    format: this.ld_format,
                    istoday: this.istoday
                });
            };
            window.onresize = function() {
                if (layerDate) {
                    layerDate.reset();
                }
            };
        };
        //开关按钮配置
        this.offBtn = function() {
            this.parentOff = "plug-OffBtn";
            //容器class
            this.childOff = "offBtn-arc";
            //子元素class 圆形
            this.offLabel = ".offLabel";
            //子元素class 文本
            this.selectedStatus = "plug-OffBtn-selected";
            //选择的状态class
            this.defaultId = "sendOffBtn";
            //默认实例事件的容器ID
            this.offStatus = 0;
            //开关状态值 0关 1开
            this.openLabel = "开启";
            //开的文本
            this.closeLabel = "关闭";
            //关的文本
            this.offLabelStatus = true;
            //是否显示文本
            this.showOffBtn = function() {
                var me = this;
                if (!this.offLabelStatus) {
                    Y(this.offLabel).hide();
                }
                Utils.addHandler(doc.getElementById(this.defaultId), "click", function() {
                    var className_ = this.className;
                    var offLabel = Y(this).find(me.offLabel);
                    //如果是开着状态就关闭
                    if (className_.indexOf(me.selectedStatus) != -1) {
                        className_ = className_.replace(me.selectedStatus, "");
                        me.closeCall();
                        me.offStatus = 0;
                        offLabel.text(me.closeLabel);
                    } else {
                        className_ += " " + me.selectedStatus;
                        me.onCall();
                        me.offStatus = 1;
                        offLabel.text(me.openLabel);
                    }
                    this.className = className_;
                    this.setAttribute("data-key", me.offStatus);
                });
            };
        };
    }
    var golobl = new globalConcat();
    /**
     * 工具箱开始
     */
    Utils = {
        /**
             * 获取字节长度
             * @param str字符
             */
        getStrLen: function(str) {
            var len = 0;
            var cnstrCount = 0;
            for (var i = 0; i < str.length; i++) {
                if (str.charCodeAt(i) > 255) cnstrCount = cnstrCount + 1;
            }
            len = str.length + cnstrCount;
            return len;
        },
        /**
             * 添加事件监听
             * @param elem节点对象  evType事件名  fn触发的函数
             * 
             */
        addHandler: function(elem, evType, fn) {
            if (elem.attachEvent) {
                elem.attachEvent("on" + evType, fn);
            } else if (elem.addEventListener) {
                elem.addEventListener(evType, fn, false);
            } else {
                elem["on" + evType] = fn;
            }
        },
        /**
             * 获取浏览器版本
             * @returns
             */
        browserVersion: function() {
            var agent = navigator.userAgent.toLowerCase();
            var regStr_ie = /msie [\d.]+;/gi;
            var regStr_winie = /windows nt [\d.]+;/gi;
            var regStr_ff = /firefox\/[\d.]+/gi;
            var regStr_chrome = /chrome\/[\d.]+/gi;
            var regStr_saf = /safari\/[\d.]+/gi;
            //IE
            if (agent.indexOf("compatible") > -1 && agent.indexOf("msie") > -1) {
                return agent.match(regStr_ie);
            }
            //IE
            if (agent.indexOf("windows nt") > -1) {
                return agent.match(regStr_winie);
            }
            //firefox
            if (agent.indexOf("firefox") > 0) {
                return agent.match(regStr_ff);
            }
            //Chrome
            if (agent.indexOf("chrome") > 0) {
                return agent.match(regStr_chrome);
            }
            //Safari
            if (agent.indexOf("safari") > 0 && agent.indexOf("chrome") < 0) {
                return agent.match(regStr_saf);
            }
        },
        /**
             * 针对IE9以下浏览器 模拟html5 input placeholaydater提示功能 
             * input获得焦点时，删除提示文本
             */
        inputFocusLabel: function(ipt) {
            var placeholder = ipt.getAttribute("placeholder");
            if (placeholder) {
                ipt.value = placeholder;
                var createInput, pnd, tempIpt = ipt;
                var iptType = ipt.type == "password";
                if (iptType) {
                    pnd = ipt.parentNode;
                    var _id = ipt.getAttribute("id");
                    var _class = ipt.className;
                    createInput = document.createElement("input");
                    createInput.setAttribute("id", _id);
                    createInput.className = _class;
                    createInput.setAttribute("placeholder", placeholder);
                    createInput.setAttribute("value", placeholder);
                    pnd.appendChild(createInput);
                    pnd.removeChild(ipt);
                    createInput.onfocus = function() {
                        if (this.value === placeholder) {
                            if (iptType) {
                                tempIpt.value = "";
                                pnd.removeChild(createInput);
                                pnd.appendChild(tempIpt);
                                tempIpt.focus();
                                ipt = tempIpt;
                            } else {
                                this.value = "";
                            }
                        }
                    };
                }
                ipt.onfocus = function() {
                    if (this.value === placeholder) {
                        this.value = "";
                    }
                };
                ipt.onblur = function() {
                    if (this.value === "" || this.value.length <= 0) {
                        if (iptType) {
                            tempIpt.value = placeholder;
                            pnd.removeChild(tempIpt);
                            pnd.appendChild(createInput);
                            ipt = createInput;
                        } else {
                            this.value = placeholder;
                        }
                    }
                };
            }
        },
        /**
             * 下拉框控件 焦点事件
             * @param obj下拉框容器 jquery对象
             * 调用方式axus.pullDownBox($('.pullDownWarp'));
             */
        pullDownBox: function(obj) {
            var ipt = obj[0];
            var pullDownData, pullResult;
            //获得焦点时触发  弹出下拉框
            obj.on("focus", function() {
                var _this = Y(this);
                _this.addClass("pullDownFocus");
                pullDownData = _this.find(".pullDownData");
                pullResult = _this.find(".pullResult");
                var height = pullDownData.height();
                var _tsHeight = _this.height();
                var top = Y(".down-arrowTip").offset().top;
                var clientHeight = doc.documentElement.clientHeight;
                var bots = clientHeight - top - _tsHeight;
                //距离底部
                if (height > bots) {
                    pullDownData.css({
                        bottom: _tsHeight + 1,
                        borderBottom: "0"
                    }).slideDown(100);
                } else {
                    pullDownData.css({
                        top: _tsHeight + 1,
                        borderTop: "0"
                    }).slideDown(100);
                }
                var pulldownLi = pullDownData.find("li");
                pulldownLi.click(function() {
                    var dataKey = Y(this).attr("data-key");
                    var text = Y(this).text();
                    pullResult.attr("data-result", dataKey).text(text);
                    obj.blur();
                }).mouseover(function() {
                    Y(this).addClass("pull-selected");
                }).mouseout(function() {
                    Y(this).removeClass("pull-selected");
                });
            });
            //离开焦点触发 还原之前样式
            obj.blur(function() {
                pullDownData.slideUp(100);
                Y(this).removeClass("pullDownFocus");
            });
        },
        /**
             * 实例化时间插件  依赖laydate插件
             * @param layer laydate函数
             * @param id_ 日期input输入容器 
             * @param iconMake 容器下一个兄弟元素icon图标是否支持点击事件true或false
             * 调用方式 axus.timerInstance("timeInput",true);
             */
        timerInstance: function(layer, id_, iconMake) {
            layerDate = layer;
            var me = this.timerInstance;
            golobl.laydate.call(me);
            me.ld_elem = id_;
            var iptObj = doc.getElementById(id_);
            iptObj.value = layerDate.now(0, this.ld_format);
            this.addHandler(iptObj, "click", function() {
                me.ld_onload();
            });
            var timerIpt = doc.getElementById(id_);
            if (iconMake) {
                var timmerIcon = Y(timerIpt).next();
                timmerIcon = timmerIcon[0];
                this.addHandler(timmerIcon, "click", function() {
                    me.ld_onload();
                });
            }
        },
        /**
             * 开关按钮插件 
             * @param onCall 开的回调
             * @param closeCall 关的回调
             * 调用方式axus.offBtnInstance({defaultId:'sendOffBtn',onCall:function(){
             *       //alert("开了");
             *   },closeCall:function(){
             *       //alert("关了");
             *   }});
             */
        offBtnInstance: function(options) {
            var me = this.offBtnInstance;
            golobl.offBtn.call(options);
            options.showOffBtn();
        },
        /**
             * 控制文本框字数限制
             * @params objArr需要控制字数限制的元素数组
             * 调用方式 axus.soMuchSize(['#titleEnter']);
             */
        soMuchSize: function(objArr) {
            for (var i in objArr) {
                var obj = Y(objArr[i]);
                var smInput = obj.find(".sm-input")[0];
                //获得输入js对象
                var dataSize = smInput.getAttribute("data-size");
                //最大输入数，必须配置
                var dataEvt = smInput.getAttribute("data-event");
                //文本框事件名
                var dataSmtNt = obj.find(".smtNtCount")[0];
                //输入字数元素
                var dataSmtCt = obj.find(".smtCount")[0];
                //最大限制字数
                dataSmtCt.innerText = dataSize;
                this.addHandler(smInput, dataEvt, this.smInputHandler());
            }
        },
        smInputHandler: function(event) {
            var _this = event.target;
            var wordSize = _this.value.length;
            if (wordSize > dataSize) {
                _this.value = _this.value.substring(0, _this.value.length - 1);
            }
            dataSmtNt.innerText = _this.value.length;
        }
    };
    module.exports = Utils;
});
