/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi.task;

import com.lxt2.javaapi.IPassiveSubmitSender;
import com.lxt2.javaapi.IRespReceiver;
import com.lxt2.javaapi.module.kpi.Performance;
import com.lxt2.javaapi.task.SendManager;
import com.lxt2.javaapi.util.MsgConstant;
import com.lxt2.protocol.IApiSubmit;
import com.lxt2.protocol.IApiSubmitResp;
import com.lxt2.protocol.cbip20.CbipContentMms;
import com.lxt2.protocol.cbip20.CbipContentMmsResp;
import com.lxt2.protocol.cbip20.CbipSubmit;
import com.lxt2.protocol.cbip20.CbipSubmitMms;
import com.lxt2.protocol.cbip20.CbipSubmitResp;
import com.lxt2.protocol.common.Standard_Head;
import com.techcenter.util.BoundedConcurrentMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendController {
    private static final Logger logger = LoggerFactory.getLogger(SendController.class);
    private static final Logger smslog = LoggerFactory.getLogger((String)"LOG_SAVE_SMS");
    private static final Logger mmslog = LoggerFactory.getLogger((String)"LOG_SAVE_MMS");
    protected boolean reSend = false;
    private boolean running = true;
    private IoSession session;
    private String sessionStr;
    private IRespReceiver respReceiver;
    private IPassiveSubmitSender passiveSubmitSender;
    private BoundedConcurrentMapExtend<Long, MsgWrapper> controlWindow = null;
    private int controlWindowSize = 16;
    private long clearTimeOut = 60000L;
    private long clearSleepTime = 60000L;
    private final Object syncSendLock = new Object();
    private Long syncSequenceId = 0L;
    private IApiSubmitResp response;
    private String type;
    private Long id = MsgConstant.getUniqueId();

    public synchronized void clear() {
        if (logger.isInfoEnabled()) {
            logger.info("\u8fde\u63a5\u65ad\u5f00\uff0c\u6e05\u7406\u73b0\u573a...");
        }
        Iterator iter = this.controlWindow.getMap().keySet().iterator();
        Set set = this.controlWindow.getMap().keySet();
        if (logger.isErrorEnabled()) {
            logger.error("\u6ed1\u52a8\u7a97\u53e3\u6e05\u7406\u4e22\u5931\u6570\u636e\u4e2a\u6570\uff1a" + set.size());
        }
        while (iter.hasNext()) {
            MsgWrapper wrapper = (MsgWrapper)this.controlWindow.remove(iter.next());
            if (wrapper == null) continue;
            IApiSubmit submit = wrapper.obj;
            if (submit instanceof CbipSubmit) {
                CbipSubmit cbipSubmit = (CbipSubmit)submit;
                CbipSubmitResp response = new CbipSubmitResp(cbipSubmit);
                response.setStatus(0);
                if (logger.isWarnEnabled()) {
                    logger.warn("\u6e05\u7406\u7684\u6ed1\u52a8\u7a97\u53e3\u91cc\u7684\u6570\u636e:submit={},response={}", (Object)submit, (Object)response);
                }
                this.toolReceive(submit, (IApiSubmitResp)response);
                continue;
            }
            if (!(submit instanceof CbipSubmitMms)) continue;
        }
        this.session.close(true);
    }

    private void toolReceive(IApiSubmit submit, IApiSubmitResp response) {
        block7: {
            try {
                if (submit instanceof CbipSubmit) {
                    Performance.addSmsResponseAl();
                    Performance.addSmsSubmitAl();
                    if (smslog.isInfoEnabled()) {
                        smslog.info(((CbipSubmit)submit).toDataString());
                    }
                } else if (submit instanceof CbipSubmitMms) {
                    Performance.addMmsResponseAl();
                    Performance.addMmsSubmitAl();
                    if (mmslog.isInfoEnabled()) {
                        mmslog.info(((CbipSubmitMms)submit).toDataString());
                    }
                }
                this.respReceiver.receive(submit, response);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void doSleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPassiveSubmitSender(IPassiveSubmitSender passiveSubmitSender) {
        this.passiveSubmitSender = passiveSubmitSender;
    }

    public void setRespReceiver(IRespReceiver respReceiver) {
        this.respReceiver = respReceiver;
    }

    public void init(IoSession session) {
        this.session = session;
        this.controlWindowSize = (Integer)session.getAttribute((Object)"Key_WindowSize");
        this.clearTimeOut = (Long)session.getAttribute((Object)"clearTimeOut");
        this.clearSleepTime = (Long)session.getAttribute((Object)"clearSleepTime");
        this.controlWindow = new BoundedConcurrentMapExtend(this.controlWindowSize);
        this.sessionStr = "@" + session.getRemoteAddress() + "-" + session.getLocalAddress();
        if (logger.isInfoEnabled()) {
            logger.info("\u521d\u59cb\u5316:{}", (Object)this.sessionStr);
        }
        this.running = true;
        this.reSend = (Boolean)session.getAttribute((Object)"reSend");
        SendManager.getInstance().registerSendController(this);
    }

    private boolean isContented() {
        return this.session != null && this.session.isConnected();
    }

    public boolean isReadyToSend() {
        return this.controlWindow.canAddEntity();
    }

    public void onReply(IApiSubmitResp iResp) {
        if (iResp instanceof CbipSubmitResp) {
            CbipSubmitResp resp = (CbipSubmitResp)iResp;
            resp.setClientReceiveTime(System.currentTimeMillis());
            MsgWrapper mw = (MsgWrapper)this.controlWindow.remove(resp.getSequenceId());
            IApiSubmit submit = null;
            if (mw != null) {
                submit = mw.obj;
            } else if (logger.isWarnEnabled()) {
                logger.warn("submit: null, response: {}", (Object)resp);
            }
            this.toolReceive(submit, (IApiSubmitResp)resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReplyContentMms(IApiSubmitResp iResp) {
        block6: {
            CbipContentMmsResp resp;
            if (iResp instanceof CbipContentMmsResp && (resp = (CbipContentMmsResp)iResp).getSequenceId() == this.syncSequenceId.longValue()) {
                this.response = resp;
                try {
                    Object object = this.syncSendLock;
                    synchronized (object) {
                        this.syncSendLock.notify();
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void start() {
        if (null != this.passiveSubmitSender) {
            AsyncSendThread worker = new AsyncSendThread();
            if (logger.isInfoEnabled()) {
                logger.info("\u542f\u52a8\u53d1\u9001\u7ebf\u7a0b {}: {}", (Object)worker.getName(), (Object)this.sessionStr);
            }
            worker.setName("\u88ab\u52a8\u53d1\u9001\u7ebf\u7a0b:" + this.getId());
            worker.start();
        }
        WindowCleanThread clearThread = new WindowCleanThread();
        if (logger.isInfoEnabled()) {
            logger.info("\u542f\u52a8\u6ed1\u52a8\u7a97\u53e3\u6e05\u7406\u7ebf\u7a0b {}: {}", (Object)clearThread.getName(), (Object)this.sessionStr);
        }
        clearThread.setName("\u6ed1\u52a8\u7a97\u53e3\u6e05\u7406\u7ebf\u7a0b:" + this.getId());
        clearThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CbipContentMmsResp synSendSubmit(CbipContentMms submit, long respTimeOut) throws Exception {
        if (submit == null) {
            return this.createFailResponse(submit, -4);
        }
        this.syncSequenceId = submit.getSequenceId();
        this.response = null;
        boolean sendFlag = false;
        int sendTime = 0;
        while (!sendFlag && sendTime++ < MsgConstant.maxSendTime) {
            WriteFuture wf = this.session.write((Object)submit);
            wf.awaitUninterruptibly();
            sendFlag = wf.isWritten();
        }
        Object object = this.syncSendLock;
        synchronized (object) {
            this.syncSendLock.wait(respTimeOut);
        }
        this.syncSequenceId = 0L;
        if (logger.isInfoEnabled() && this.response != null) {
            logger.info("\u6536\u5f69\u4fe1\u8d44\u6e90\u8fd4\u56deresponse\uff0c\u8d44\u6e90ID\uff1a{}", (Object)((CbipContentMmsResp)this.response).getSysResourceID());
        }
        if (this.response == null) {
            return this.createFailResponse(submit, -7);
        }
        return (CbipContentMmsResp)this.response;
    }

    private CbipContentMmsResp createFailResponse(CbipContentMms submit, int stat) {
        CbipContentMmsResp response = new CbipContentMmsResp();
        response.setSequenceId(submit.getSequenceId());
        response.setCommandStatus(0);
        response.setStatus(stat);
        return response;
    }

    public void trySend(IApiSubmit obj, boolean isJoin) throws InterruptedException {
        if (logger.isInfoEnabled()) {
            logger.info("send by id:" + this.getId());
        }
        if (!(obj instanceof Standard_Head)) {
            if (logger.isWarnEnabled()) {
                logger.warn("\u6d88\u606f\u5bf9\u8c61\u672a\u7ee7\u627fStandard_Head\uff0c\u5ffd\u7565\u5904\u7406");
            }
            return;
        }
        Standard_Head head = (Standard_Head)obj;
        this.controlWindow.put(head.getSequenceId(), new MsgWrapper(obj));
        boolean sendFlag = false;
        int sendTime = 0;
        while (!sendFlag && sendTime++ < MsgConstant.maxSendTime) {
            WriteFuture wf = this.session.write((Object)obj);
            if (isJoin) {
                wf.awaitUninterruptibly();
                sendFlag = wf.isWritten();
                continue;
            }
            sendFlag = true;
        }
        MsgWrapper msgWrapper = (MsgWrapper)this.controlWindow.get(head.getSequenceId());
        if (msgWrapper != null) {
            msgWrapper.tick = System.currentTimeMillis();
        }
    }

    public Long getId() {
        return this.id;
    }

    private class MsgWrapper {
        public long tick = System.currentTimeMillis();
        public IApiSubmit obj;

        public MsgWrapper(IApiSubmit obj) {
            this.obj = obj;
            if (obj instanceof CbipSubmit) {
                ((CbipSubmit)obj).setClientSubmitTime(System.currentTimeMillis());
            } else if (obj instanceof CbipSubmitMms) {
                ((CbipSubmitMms)obj).setClientSubmitTime(System.currentTimeMillis());
            }
        }
    }

    private class BoundedConcurrentMapExtend<K, V>
    extends BoundedConcurrentMap<K, V> {
        private final Integer mapSize;

        public Integer getMapSize() {
            return this.mapSize;
        }

        public BoundedConcurrentMapExtend(int bound) {
            super(bound);
            this.mapSize = bound;
        }

        public boolean canAddEntity() {
            return super.getMap().size() < this.mapSize;
        }
    }

    private class WindowCleanThread
    extends Thread {
        private WindowCleanThread() {
        }

        @Override
        public void run() {
            while (SendController.this.session.isConnected()) {
                try {
                    ConcurrentHashMap<Long, MsgWrapper> resendList = this.checkOverTime();
                    if (resendList != null) {
                        for (Map.Entry entry : resendList.entrySet()) {
                            MsgWrapper msg = (MsgWrapper)entry.getValue();
                            IApiSubmit obj = msg.obj;
                            if (SendController.this.reSend) {
                                SendController.this.trySend(obj, true);
                                continue;
                            }
                            if (logger.isWarnEnabled()) {
                                logger.warn("response: null, submit: {}", (Object)obj);
                            }
                            CbipSubmitResp timeout = new CbipSubmitResp();
                            timeout.setStatus(-20);
                            SendController.this.toolReceive(obj, (IApiSubmitResp)timeout);
                        }
                    }
                    resendList.clear();
                    Thread.sleep(SendController.this.clearSleepTime);
                }
                catch (Throwable e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error(e.getMessage(), e);
                }
            }
            Set keySet = SendController.this.controlWindow.getMap().keySet();
            if (logger.isErrorEnabled()) {
                logger.error("SendController\u88ab\u5173\u95ed, \u6ed1\u52a8\u7a97\u53e3\u4e22\u5931\u6570\u636e\u4e2a\u6570\uff1a" + keySet.size());
            }
        }

        private ConcurrentHashMap<Long, MsgWrapper> checkOverTime() {
            ConcurrentHashMap<Long, MsgWrapper> ret = new ConcurrentHashMap<Long, MsgWrapper>();
            for (Long key : SendController.this.controlWindow.getMap().keySet()) {
                MsgWrapper wrapp;
                long currentTimeMillis;
                MsgWrapper mw = (MsgWrapper)SendController.this.controlWindow.get(key);
                if (mw == null || (currentTimeMillis = System.currentTimeMillis()) - mw.tick <= SendController.this.clearTimeOut || (wrapp = (MsgWrapper)SendController.this.controlWindow.remove(key)) == null) continue;
                if (logger.isErrorEnabled()) {
                    logger.error("\u6e05\u7406submit\uff1a{},\u65f6\u95f4\u5dee\uff1a{}", (Object)mw.obj, (Object)(currentTimeMillis - mw.tick));
                }
                ret.put(key, wrapp);
            }
            return ret;
        }
    }

    private class AsyncSendThread
    extends Thread {
        private AsyncSendThread() {
        }

        @Override
        public void run() {
            while (SendController.this.session.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("get submit begin");
                }
                Object obj = this.getSubmit();
                if (logger.isDebugEnabled()) {
                    logger.debug("get submit end");
                }
                if (obj != null) {
                    if (obj instanceof IApiSubmit) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("session write begin");
                        }
                        try {
                            SendController.this.trySend((IApiSubmit)obj, true);
                        }
                        catch (InterruptedException e) {
                            if (logger.isErrorEnabled()) {
                                logger.error("SendController\u53d1\u9001\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
                            }
                            SendController.this.running = false;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("session write end");
                        }
                    } else if (logger.isErrorEnabled()) {
                        logger.error("SendController find out a error obj:{}", obj);
                    }
                } else {
                    SendController.this.doSleep(1000L);
                }
                if (SendController.this.isContented()) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("\u8fde\u63a5\u65ad\u5f00 \u9000\u51fa\u53d1\u9001\u7684\u5faa\u73af");
                }
                SendController.this.running = false;
            }
            SendController.this.clear();
        }

        private Object getSubmit() {
            IApiSubmit obj = null;
            try {
                obj = SendController.this.passiveSubmitSender.getSubmit();
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("\u53d6\u6d88\u606f\u51fa\u9519", (Throwable)e);
                }
                obj = null;
                SendController.this.doSleep(1000L);
            }
            return obj;
        }
    }
}

