/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi.handler.cbip20;

import com.lxt2.javaapi.IReceiver;
import com.lxt2.javaapi.module.kpi.Performance;
import com.lxt2.protocol.cbip20.CbipReport;
import com.lxt2.protocol.cbip20.CbipReportResp;
import com.lxt2.protocol.common.ProtocolUtil;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportReceiverHandler
implements MessageHandler<CbipReport> {
    private static final Logger logger = LoggerFactory.getLogger(ReportReceiverHandler.class);
    private static final Logger smslog = LoggerFactory.getLogger((String)"LOG_SAVE_SMS");
    private static final Logger mmslog = LoggerFactory.getLogger((String)"LOG_SAVE_MMS");

    public void handleMessage(IoSession session, CbipReport message) throws Exception {
        block6: {
            try {
                message.setClientReceiveTime(System.currentTimeMillis());
                IReceiver receiver = (IReceiver)session.getAttribute((Object)"REPORT_RECEIVER");
                receiver.receive(message);
                if (ProtocolUtil.isMms((short)message.getMessageFormat())) {
                    Performance.addMmsReportAl();
                    if (mmslog.isWarnEnabled()) {
                        mmslog.warn(message.toDataString());
                    }
                } else {
                    Performance.addSmsReportAl();
                    if (smslog.isWarnEnabled()) {
                        smslog.warn(message.toDataString());
                    }
                }
                CbipReportResp resp = new CbipReportResp(message);
                resp.setStatus(0);
                session.write((Object)resp);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

