/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi.handler.cbip20;

import com.lxt2.protocol.IDataPackage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.demux.DemuxingProtocolCodecFactory;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.apache.mina.handler.demux.ExceptionHandler;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoHandlerAdapter
extends DemuxingIoHandler {
    protected static final Logger logger = LoggerFactory.getLogger(IoHandlerAdapter.class);
    protected List<Class<MessageDecoder>> decoderList = null;
    protected HashMap<Class<IDataPackage>, Class<MessageEncoder<?>>> encoderMap = null;
    protected HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> receivedHandlerList = null;
    protected HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> sentHandlerList = null;
    protected HashMap<Class<Throwable>, ExceptionHandler<Throwable>> exceptionHandlerList = null;

    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        logger.isInfoEnabled();
        DemuxingProtocolCodecFactory factory = new DemuxingProtocolCodecFactory();
        if (this.decoderList != null) {
            for (Class clazz : this.decoderList) {
                factory.addMessageDecoder(clazz);
            }
        }
        if (this.encoderMap != null) {
            for (Map.Entry entry : this.encoderMap.entrySet()) {
                factory.addMessageEncoder((Class)entry.getKey(), (Class)entry.getValue());
            }
        }
        session.getFilterChain().addLast("protocolCodecFactory", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)factory));
        if (this.receivedHandlerList != null) {
            for (Map.Entry entry : this.receivedHandlerList.entrySet()) {
                super.addReceivedMessageHandler((Class)entry.getKey(), (MessageHandler)entry.getValue());
            }
        }
        if (this.sentHandlerList != null) {
            for (Map.Entry entry : this.sentHandlerList.entrySet()) {
                super.addSentMessageHandler((Class)entry.getKey(), (MessageHandler)entry.getValue());
            }
        }
        if (this.exceptionHandlerList != null) {
            for (Map.Entry entry : this.exceptionHandlerList.entrySet()) {
                super.addExceptionHandler((Class)entry.getKey(), (ExceptionHandler)entry.getValue());
            }
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
    }

    public void sessionClosed(IoSession session) throws Exception {
        super.sessionClosed(session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(session, status);
    }

    public List<Class<MessageDecoder>> getDecoderList() {
        return this.decoderList;
    }

    public void setDecoderList(List<Class<MessageDecoder>> decoderList) {
        this.decoderList = decoderList;
    }

    public HashMap<Class<IDataPackage>, Class<MessageEncoder<?>>> getEncoderMap() {
        return this.encoderMap;
    }

    public void setEncoderMap(HashMap<Class<IDataPackage>, Class<MessageEncoder<?>>> encoderMap) {
        this.encoderMap = encoderMap;
    }

    public HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> getReceivedHandlerList() {
        return this.receivedHandlerList;
    }

    public void setReceivedHandlerList(HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> receivedHandlerList) {
        this.receivedHandlerList = receivedHandlerList;
    }

    public HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> getSentHandlerList() {
        return this.sentHandlerList;
    }

    public void setSentHandlerList(HashMap<Class<IDataPackage>, MessageHandler<IDataPackage>> sentHandlerList) {
        this.sentHandlerList = sentHandlerList;
    }

    public HashMap<Class<Throwable>, ExceptionHandler<Throwable>> getExceptionHandlerList() {
        return this.exceptionHandlerList;
    }

    public void setExceptionHandlerList(HashMap<Class<Throwable>, ExceptionHandler<Throwable>> exceptionHandlerList) {
        this.exceptionHandlerList = exceptionHandlerList;
    }
}

