/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi.handler.cbip20;

import com.lxt2.javaapi.IReceiver;
import com.lxt2.javaapi.module.kpi.Performance;
import com.lxt2.protocol.cbip20.CbipDeliver;
import com.lxt2.protocol.cbip20.CbipDeliverResp;
import com.lxt2.protocol.common.ProtocolUtil;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliverReceiverHandler
implements MessageHandler<CbipDeliver> {
    private static final Logger logger = LoggerFactory.getLogger(DeliverReceiverHandler.class);
    private static final Logger smslog = LoggerFactory.getLogger((String)"LOG_SAVE_SMS");
    private static final Logger mmslog = LoggerFactory.getLogger((String)"LOG_SAVE_MMS");

    public void handleMessage(IoSession session, CbipDeliver message) throws Exception {
        block6: {
            try {
                message.setClientReceiveTime(System.currentTimeMillis());
                IReceiver receiver = (IReceiver)session.getAttribute((Object)"DELIVER_RECEIVER");
                receiver.receive(message);
                if (ProtocolUtil.isMms((short)message.getMessageFormat())) {
                    if (mmslog.isErrorEnabled()) {
                        mmslog.error(message.toDataString());
                    }
                } else {
                    Performance.addDeliverAl();
                    if (smslog.isErrorEnabled()) {
                        smslog.error(message.toDataString());
                    }
                }
                CbipDeliverResp resp = new CbipDeliverResp(message);
                resp.setStatus(0);
                session.write((Object)resp);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

