/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi.handler.cbip20;

import com.lxt2.javaapi.handler.cbip20.CommonHandler;
import com.lxt2.javaapi.handler.cbip20.ContentMmsRespReceiverHandler;
import com.lxt2.javaapi.handler.cbip20.DeliverReceiverHandler;
import com.lxt2.javaapi.handler.cbip20.IoHandlerAdapter;
import com.lxt2.javaapi.handler.cbip20.LoginRespReceiverHandler;
import com.lxt2.javaapi.handler.cbip20.ReportReceiverHandler;
import com.lxt2.javaapi.handler.cbip20.SubmitRespReceiverHandler;
import com.lxt2.javaapi.util.CodecFactory;
import com.lxt2.javaapi.util.CommonExceptionHandler;
import com.lxt2.javaapi.util.MsgConstant;
import com.lxt2.protocol.cbip20.CbipActive;
import com.lxt2.protocol.cbip20.CbipActiveResp;
import com.lxt2.protocol.cbip20.CbipContentMms;
import com.lxt2.protocol.cbip20.CbipContentMmsResp;
import com.lxt2.protocol.cbip20.CbipDeliver;
import com.lxt2.protocol.cbip20.CbipDeliverResp;
import com.lxt2.protocol.cbip20.CbipLogin;
import com.lxt2.protocol.cbip20.CbipLoginResp;
import com.lxt2.protocol.cbip20.CbipReport;
import com.lxt2.protocol.cbip20.CbipReportResp;
import com.lxt2.protocol.cbip20.CbipSubmit;
import com.lxt2.protocol.cbip20.CbipSubmitMms;
import com.lxt2.protocol.cbip20.CbipSubmitResp;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cbip20IoHandler
extends IoHandlerAdapter {
    private static final Logger coagentLogger = LoggerFactory.getLogger((String)"CoagentLogger");

    public Cbip20IoHandler() {
        this.setDecoderList(CodecFactory.getDecoderList("cbip20"));
        this.setEncoderMap(CodecFactory.getEncoderMap("cbip20"));
        this.addSentMessageHandler(CbipLogin.class, new CommonHandler());
        this.addSentMessageHandler(CbipActive.class, new CommonHandler());
        this.addSentMessageHandler(CbipSubmit.class, new CommonHandler());
        this.addSentMessageHandler(CbipReportResp.class, new CommonHandler());
        this.addSentMessageHandler(CbipDeliverResp.class, new CommonHandler());
        this.addSentMessageHandler(CbipContentMms.class, new CommonHandler());
        this.addSentMessageHandler(CbipSubmitMms.class, new CommonHandler());
        this.addReceivedMessageHandler(CbipLoginResp.class, new LoginRespReceiverHandler());
        this.addReceivedMessageHandler(CbipActiveResp.class, new CommonHandler());
        this.addReceivedMessageHandler(CbipContentMmsResp.class, new ContentMmsRespReceiverHandler());
        this.addReceivedMessageHandler(CbipSubmitResp.class, new SubmitRespReceiverHandler());
        this.addReceivedMessageHandler(CbipReport.class, new ReportReceiverHandler());
        this.addReceivedMessageHandler(CbipDeliver.class, new DeliverReceiverHandler());
        this.addExceptionHandler(Throwable.class, (ExceptionHandler)new CommonExceptionHandler());
        this.addExceptionHandler(RuntimeException.class, (ExceptionHandler)new CommonExceptionHandler());
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        if (logger.isInfoEnabled()) {
            logger.info("sessionCreated");
        }
    }

    public void superSessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        this.superSessionOpened(session);
        CbipLogin cbipLogin = this.getCbipLogin();
        for (IoSession s : session.getService().getManagedSessions().values()) {
            CbipLogin login = (CbipLogin)s.getAttribute((Object)"LOGIN");
            if (login == null || login.getLoginType() != 0) continue;
            cbipLogin.setLoginType((byte)1);
            break;
        }
        session.setAttribute((Object)"SessionType", (Object)cbipLogin.getLoginType());
        session.setAttribute((Object)"LOGIN", (Object)cbipLogin);
        WriteFuture write = session.write((Object)cbipLogin);
        write.awaitUninterruptibly(30000L);
        if (logger.isInfoEnabled()) {
            logger.info("\u53d1\u9001\u767b\u5f55\u4fe1\u606f");
        }
    }

    private CbipLogin getCbipLogin() throws Exception {
        CbipLogin login = new CbipLogin();
        login.setClientID(MsgConstant.clientId);
        login.setUserName(MsgConstant.loginName);
        login.setPassword(MsgConstant.password);
        login.setVersion(MsgConstant.loginVersion);
        return login;
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        super.sessionIdle(session, status);
        boolean connectFlag = (Boolean)session.getAttribute((Object)"ConnectFlag");
        if (!connectFlag) {
            CbipLogin login = this.getCbipLogin();
            session.write((Object)login);
        } else {
            CbipActive active = new CbipActive();
            session.write((Object)active);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        super.messageReceived(session, message);
        session.updateThroughput(System.currentTimeMillis(), false);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        super.messageSent(session, message);
    }
}

