/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi;

import com.lxt2.javaapi.IPassiveSubmitSender;
import com.lxt2.javaapi.IReceiver;
import com.lxt2.javaapi.IRespReceiver;
import com.lxt2.javaapi.handler.cbip20.Cbip20IoHandler;
import com.lxt2.javaapi.handler.cbip20.IoHandlerAdapter;
import com.lxt2.javaapi.task.SendController;
import com.lxt2.javaapi.task.SendManager;
import com.lxt2.javaapi.util.MsgConstant;
import com.lxt2.protocol.cbip20.CbipDeliver;
import com.lxt2.protocol.cbip20.CbipReport;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEngine {
    private Logger logger = LoggerFactory.getLogger(ClientEngine.class);
    private IPassiveSubmitSender passiveSubmitSender;
    private IRespReceiver respReceiver;
    private IReceiver<CbipReport> reportReceiver;
    private IReceiver<CbipDeliver> deliverReceiver;
    private static final long CONNECT_TIMEOUT = 3000L;
    private final IoHandlerAdapter handler = new Cbip20IoHandler();
    private Map<Long, IoSession> sessionStatus = new ConcurrentHashMap<Long, IoSession>();
    private IoConnector connector;
    private AtomicBoolean running = new AtomicBoolean(false);

    public ClientEngine(IRespReceiver respReceiver, IReceiver<CbipReport> reportReceiver, IReceiver<CbipDeliver> deliverReceiver) {
        this.respReceiver = respReceiver;
        this.reportReceiver = reportReceiver;
        this.deliverReceiver = deliverReceiver;
    }

    public ClientEngine(IRespReceiver respReceiver, IReceiver<CbipReport> reportReceiver, IReceiver<CbipDeliver> deliverReceiver, IPassiveSubmitSender passiveSubmitSender) {
        this.respReceiver = respReceiver;
        this.reportReceiver = reportReceiver;
        this.deliverReceiver = deliverReceiver;
        this.passiveSubmitSender = passiveSubmitSender;
    }

    public void init() {
        this.connector = new NioSocketConnector();
        DefaultIoFilterChainBuilder chain = this.connector.getFilterChain();
        ExecutorFilter executorFilter = new ExecutorFilter();
        chain.addLast("executor", (IoFilter)executorFilter);
        this.connector.setHandler((IoHandler)this.getHandler());
        this.connector.setConnectTimeoutMillis(3000L);
    }

    public void start() {
        this.init();
        this.running.set(true);
        for (int i = 0; i < MsgConstant.connectNum; ++i) {
            this.connectServer();
        }
        Thread thread = new Thread(new CheckConnectStatus());
        thread.setDaemon(true);
        thread.setName("\u8fde\u63a5\u68c0\u6d4b\u7ebf\u7a0b");
        thread.start();
    }

    private boolean connectServer() {
        InetSocketAddress serverAddress = new InetSocketAddress(MsgConstant.serverIp, MsgConstant.serverPort);
        ConnectFuture future = this.connector.connect((SocketAddress)serverAddress);
        future.awaitUninterruptibly(30000L);
        if (future.getException() != null) {
            this.logger.error("\u8fde\u63a5\u5931\u8d25\uff1a" + future.getException() + serverAddress);
            return false;
        }
        IoSession session = future.getSession();
        SendController sender = new SendController();
        sender.setPassiveSubmitSender(this.passiveSubmitSender);
        sender.setRespReceiver(this.respReceiver);
        session.setAttribute((Object)"sender", (Object)sender);
        if (SendManager.getInstance().getMMSSender() == null) {
            sender.setType("SEND_TYPE_MMS");
        } else {
            sender.setType("SEND_TYPE_MT");
        }
        int idletime = MsgConstant.IdleTime < MsgConstant.reconnectTime ? MsgConstant.IdleTime : MsgConstant.reconnectTime;
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, idletime);
        ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(MsgConstant.inBufferSize);
        ((SocketSessionConfig)session.getConfig()).setSendBufferSize(MsgConstant.outBufferSize);
        session.setAttribute((Object)"ConnectFlag", (Object)false);
        session.setAttribute((Object)"Key_WindowSize", (Object)MsgConstant.controlWindowsSize);
        session.setAttribute((Object)"clearTimeOut", (Object)MsgConstant.clearTimeOut);
        session.setAttribute((Object)"ecType", (Object)MsgConstant.ecType);
        session.setAttribute((Object)"reSend", (Object)MsgConstant.reSend);
        session.setAttribute((Object)"IS_SECURITY", (Object)MsgConstant.security);
        session.setAttribute((Object)"clearSleepTime", (Object)MsgConstant.clearSleepTime);
        session.setAttribute((Object)"REPORT_RECEIVER", this.reportReceiver);
        session.setAttribute((Object)"DELIVER_RECEIVER", this.deliverReceiver);
        this.sessionStatus.put(sender.getId(), session);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return true;
    }

    public void stop() {
        this.running.set(false);
        this.connector.dispose();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isConnected() {
        for (IoSession s : this.sessionStatus.values()) {
            if (!s.isConnected()) continue;
            return true;
        }
        return false;
    }

    public String getConnectionStatus() {
        int connectCount = 0;
        for (IoSession s : this.sessionStatus.values()) {
            if (!s.isConnected()) continue;
            ++connectCount;
        }
        return connectCount + "/" + 2;
    }

    public void setRunning(boolean running) {
        this.running.set(running);
    }

    public IoHandlerAdapter getHandler() {
        return this.handler;
    }

    class CheckConnectStatus
    implements Runnable {
        CheckConnectStatus() {
        }

        @Override
        public void run() {
            while (ClientEngine.this.running.get()) {
                for (int i = 0; i < MsgConstant.connectNum - ClientEngine.this.sessionStatus.size(); ++i) {
                    ClientEngine.this.connectServer();
                }
                for (Map.Entry s : ClientEngine.this.sessionStatus.entrySet()) {
                    if (!((IoSession)s.getValue()).isClosing()) continue;
                    ClientEngine.this.logger.warn("session\u8fde\u63a5\u5f02\u5e38\uff0c\u5173\u95ed\u540e\u91cd\u65b0\u8fde\u63a5");
                    ClientEngine.this.connectServer();
                    ClientEngine.this.sessionStatus.remove(s.getKey());
                }
                try {
                    Thread.sleep(MsgConstant.reconnectTime);
                }
                catch (InterruptedException e) {
                    ClientEngine.this.logger.error("\u68c0\u6d4b\u8fde\u63a5\u7ebf\u7a0b\u88ab\u6253\u65ad");
                }
            }
        }
    }
}

