/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnector
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClientConnector.class);
    private static final int CONNECT_TIMEOUT = 300000;
    private final String host;
    private final int port;
    private final IoHandler handler;
    ExecutorFilter executorFilter;
    private boolean running = true;
    private IoConnector connector;
    private IoSession session;
    private Object lock = new Object();

    public ClientConnector(String host, int port, IoHandler handler) {
        this.host = host;
        this.port = port;
        this.handler = handler;
    }

    @Override
    public void run() {
        this.connector = new NioSocketConnector();
        DefaultIoFilterChainBuilder chain = this.connector.getFilterChain();
        this.executorFilter = new ExecutorFilter();
        chain.addLast("executor1", (IoFilter)this.executorFilter);
        chain.addLast("logging", (IoFilter)new LoggingFilter());
        this.connector.setHandler(this.handler);
        this.connector.setConnectTimeoutMillis(300000L);
        this.socketConnect();
        this.connectCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void socketConnect() {
        while (this.running) {
            try {
                ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
                future.awaitUninterruptibly(30000L);
                if (!future.isConnected()) break;
                this.session = future.getSession();
                if (!logger.isInfoEnabled()) break;
                logger.info("\u8fde\u63a5 :{}, \u7aef\u53e3:{}", (Object)this.host, (Object)this.port);
                break;
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u6253\u5f00\u8fde\u63a5\u51fa\u9519\uff0c30\u79d2\u540e\u91cd\u8bd5!", (Throwable)e);
                }
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectCheck() {
        while (this.running) {
            Object object;
            if (this.isConnected()) {
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("\u8fde\u63a5\u65ad\u5f00!");
            }
            this.clear(false);
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.running) continue;
            this.socketConnect();
        }
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public boolean isLogin() {
        if (this.session != null) {
            int sessionType = (Integer)this.session.getAttribute((Object)"SessionType");
            return sessionType == 2 || this.session.getAttribute((Object)"sender") != null;
        }
        return false;
    }

    private void clear(boolean dispose) {
        if (logger.isInfoEnabled()) {
            logger.info("\u6e05\u7406\u8fde\u63a5\u8d44\u6e90");
        }
        if (this.session != null) {
            this.session.close(false).awaitUninterruptibly();
        }
        if (this.connector != null && dispose) {
            this.connector.dispose();
            if (this.executorFilter != null) {
                this.executorFilter.destroy();
                this.executorFilter = null;
            }
        }
    }

    public void init() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block6: {
            if (logger.isInfoEnabled()) {
                logger.info("\u5173\u95ed\u8fde\u63a5");
            }
            try {
                this.running = false;
                this.clear(true);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block6;
                logger.warn("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

