/*
 * Decompiled with CFR 0.152.
 */
package com.lxt2.javaapi;

import com.lxt2.javaapi.IActiveSubmitSender;
import com.lxt2.javaapi.task.SendController;
import com.lxt2.javaapi.task.SendManager;
import com.lxt2.protocol.IApiSubmit;
import com.lxt2.protocol.cbip20.CbipContentMms;
import com.lxt2.protocol.cbip20.CbipContentMmsResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveSubmitSender
implements IActiveSubmitSender {
    private static final Logger logger = LoggerFactory.getLogger(ActiveSubmitSender.class);
    private final Object lock = new Object();
    private long mmsTimeout = 5L;

    public void setMmsTimeout(long mmsTimeout) {
        this.mmsTimeout = mmsTimeout;
    }

    @Override
    public CbipContentMmsResp sendMMSContent(CbipContentMms submit) {
        try {
            return SendManager.getInstance().getMMSSender().synSendSubmit(submit, this.mmsTimeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendSubmit(IApiSubmit submit) {
        SendController sendController = SendManager.getInstance().getActiveSendCoroller();
        while (null == sendController) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(5L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            sendController = SendManager.getInstance().getActiveSendCoroller();
        }
        try {
            sendController.trySend(submit, true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

