package weblogic.webservice.cg;

import java.text.MessageFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
 
/** 
 * Copyright (c) 2003 by BEA Inc. All Rights Reserved.
 * @exclude
 */
public class WebServiceCGRootPathTextFormatter {
  private Localizer l10n;
  private boolean format=false;
  // constructors

  public WebServiceCGRootPathTextFormatter() {
    l10n = L10nLookup.getLocalizer(Locale.getDefault(), "weblogic.webservice.cg.WebServiceCGRootPathTextLocalizer");
  }

  public WebServiceCGRootPathTextFormatter(Locale l) {
    l10n = L10nLookup.getLocalizer(l, "weblogic.webservice.cg.WebServiceCGRootPathTextLocalizer");
  }

  public static WebServiceCGRootPathTextFormatter getInstance() {
    return new WebServiceCGRootPathTextFormatter();
  }

  public static WebServiceCGRootPathTextFormatter getInstance(Locale l) {
    return new WebServiceCGRootPathTextFormatter(l);
  }

  public void setExtendedFormat(boolean fmt) {
    format = fmt;
  }

  public boolean getExtendedFormat() { return format; }


  /**
   * weblogic.webservice.tools.pagegen
   */
  public String cgToolsPagegen()  {
    String fmt  = "";
    String id = "cgToolsPagegen" ;
    String subsystem = "WebService CG Root Path" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }


}
